/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.event.TokenValidatedEvent;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.reader.TokenResolver;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class TokenAuthenticationFetcher
implements AuthenticationFetcher {
    public static final Integer ORDER = 0;
    protected final Collection<TokenValidator> tokenValidators;
    protected final ApplicationEventPublisher eventPublisher;
    private final TokenResolver tokenResolver;

    @Inject
    public TokenAuthenticationFetcher(Collection<TokenValidator> tokenValidators, TokenResolver tokenResolver, ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.tokenResolver = tokenResolver;
        this.tokenValidators = tokenValidators;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        Optional<String> token = this.tokenResolver.resolveToken(request);
        if (!token.isPresent()) {
            return Flowable.empty();
        }
        String tokenValue = token.get();
        return Flowable.fromIterable(this.tokenValidators).flatMap(tokenValidator -> tokenValidator.validateToken(tokenValue, request)).firstElement().map(authentication -> {
            request.setAttribute(SecurityFilter.TOKEN, (Object)tokenValue);
            this.eventPublisher.publishEvent((Object)new TokenValidatedEvent(tokenValue));
            return authentication;
        }).toFlowable();
    }

    public int getOrder() {
        return ORDER;
    }
}

