/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.authentication.AuthenticationUserDetailsAdapter;
import io.micronaut.security.authentication.Authenticator;
import io.micronaut.security.authentication.UserDetails;
import io.micronaut.security.authentication.UsernamePasswordCredentials;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.token.config.TokenConfiguration;
import io.reactivex.Flowable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(property="micronaut.security.basic-auth.enabled", notEquals="false")
@Singleton
public class BasicAuthAuthenticationFetcher
implements AuthenticationFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(BasicAuthAuthenticationFetcher.class);
    private static final String PREFIX = "Basic ";
    private final Authenticator authenticator;
    private final TokenConfiguration configuration;

    public BasicAuthAuthenticationFetcher(Authenticator authenticator, TokenConfiguration configuration) {
        this.authenticator = authenticator;
        this.configuration = configuration;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        Optional credentials = request.getHeaders().getAuthorization().flatMap(this::parseCredentials);
        if (credentials.isPresent()) {
            Flowable authenticationResponse = Flowable.fromPublisher(this.authenticator.authenticate(request, (AuthenticationRequest)credentials.get()));
            return authenticationResponse.switchMap(response -> {
                if (response.isAuthenticated()) {
                    UserDetails userDetails = response.getUserDetails().get();
                    return Flowable.just((Object)new AuthenticationUserDetailsAdapter(userDetails, this.configuration.getRolesName(), this.configuration.getNameKey()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not authenticate {}", (Object)((UsernamePasswordCredentials)credentials.get()).getUsername());
                }
                return Flowable.empty();
            });
        }
        return Publishers.empty();
    }

    @NonNull
    public Optional<UsernamePasswordCredentials> parseCredentials(@NonNull String authorization) {
        return Optional.of(authorization).filter(s -> s.startsWith(PREFIX)).map(s -> s.substring(PREFIX.length())).flatMap(this::decode);
    }

    private Optional<UsernamePasswordCredentials> decode(String credentials) {
        byte[] decoded;
        try {
            decoded = Base64.getDecoder().decode(credentials);
        }
        catch (IllegalArgumentException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error while trying to Base 64 decode: {}", (Object)credentials);
            }
            return Optional.empty();
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        String[] parts = token.split(":");
        if (parts.length < 2) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bad format of the basic auth header - Delimiter : not found");
            }
            return Optional.empty();
        }
        return Optional.of(new UsernamePasswordCredentials(parts[0], parts[1]));
    }
}

