/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.event.TokenValidatedEvent;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.reader.TokenResolver;
import io.micronaut.security.token.validator.TokenValidator;
import io.reactivex.Flowable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;

@Singleton
public class TokenAuthenticationFetcher
implements AuthenticationFetcher {
    public static final Integer ORDER = 0;
    protected final Collection<TokenValidator> tokenValidators;
    protected final ApplicationEventPublisher eventPublisher;
    private final TokenResolver tokenResolver;

    @Inject
    public TokenAuthenticationFetcher(Collection<TokenValidator> tokenValidators, TokenResolver tokenResolver, ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.tokenResolver = tokenResolver;
        this.tokenValidators = tokenValidators;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        Optional<String> token = this.tokenResolver.resolveToken(request);
        if (!token.isPresent()) {
            return Flowable.empty();
        }
        Iterator<TokenValidator> tokenValidatorIterator = this.tokenValidators.iterator();
        String tokenString = token.get();
        return this.attemptTokenValidation(request, tokenValidatorIterator, tokenString);
    }

    public int getOrder() {
        return ORDER;
    }

    private Flowable<Authentication> attemptTokenValidation(HttpRequest<?> request, Iterator<TokenValidator> tokenValidatorIterator, String tokenString) {
        if (tokenValidatorIterator.hasNext()) {
            TokenValidator tokenValidator = tokenValidatorIterator.next();
            return Flowable.just((Object)tokenString).switchMap(tokenValue -> Flowable.fromPublisher(tokenValidator.validateToken((String)tokenValue, request)).map(authentication -> {
                request.setAttribute(SecurityFilter.TOKEN, tokenValue);
                this.eventPublisher.publishEvent((Object)new TokenValidatedEvent(tokenValue));
                return authentication;
            })).switchIfEmpty(this.attemptTokenValidation(request, tokenValidatorIterator, tokenString));
        }
        return Flowable.empty();
    }
}

