/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.http.filter.OncePerRequestHttpServerFilter;
import io.micronaut.security.filters.SecurityFilter;
import java.security.Principal;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class PrincipalArgumentBinder
implements TypedRequestArgumentBinder<Principal> {
    public Argument<Principal> argumentType() {
        return Argument.of(Principal.class);
    }

    public ArgumentBinder.BindingResult<Principal> bind(ArgumentConversionContext<Principal> context, HttpRequest<?> source) {
        if (source.getAttributes().contains(OncePerRequestHttpServerFilter.getKey(SecurityFilter.class))) {
            Optional existing = source.getUserPrincipal();
            if (existing.isPresent()) {
                return () -> existing;
            }
            return ArgumentBinder.BindingResult.EMPTY;
        }
        return ArgumentBinder.BindingResult.UNSATISFIED;
    }
}

