/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.session.SessionIdResolver;
import io.micronaut.session.Session;
import io.micronaut.session.http.SessionForRequest;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requires(property="micronaut.security.sessionid-resolver.httpsession-id.enabled", value="true", defaultValue="true")
@Internal
@Singleton
final class HttpSessionSessionIdResolver
implements SessionIdResolver<HttpRequest<?>> {
    HttpSessionSessionIdResolver() {
    }

    @NonNull
    public Optional<String> findSessionId(@NonNull HttpRequest<?> request) {
        return SessionForRequest.find(request).map(Session::getId);
    }
}

