/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.session;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.handlers.LogoutHandler;
import io.micronaut.security.session.SessionAuthenticationModeCondition;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionFilter;
import jakarta.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;

@Requires(condition=SessionAuthenticationModeCondition.class)
@Singleton
public class SessionLogoutHandler
implements LogoutHandler {
    @Nullable
    protected final String logout;

    public SessionLogoutHandler(RedirectConfiguration redirectConfiguration, RedirectService redirectService) {
        this.logout = redirectConfiguration.isEnabled() ? redirectService.logoutUrl() : null;
    }

    public MutableHttpResponse<?> logout(HttpRequest<?> request) {
        this.removeAuthenticationFromSession(request);
        try {
            return this.logout == null ? HttpResponse.ok() : HttpResponse.seeOther((URI)new URI(this.logout));
        }
        catch (URISyntaxException e) {
            return HttpResponse.serverError();
        }
    }

    private void removeAuthenticationFromSession(HttpRequest<?> request) {
        MutableConvertibleValues attrs = request.getAttributes();
        Optional existing = attrs.get(HttpSessionFilter.SESSION_ATTRIBUTE, Session.class);
        if (existing.isPresent()) {
            Session session = (Session)existing.get();
            session.remove(SecurityFilter.AUTHENTICATION);
        }
    }
}

