/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.configuration;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.configuration.OauthConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdAdditionalClaimsConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClaimsValidationConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndSessionConfiguration;
import java.util.Optional;

@ConfigurationProperties(value="micronaut.security.oauth2")
public class OauthConfigurationProperties
implements OauthConfiguration {
    public static final String PREFIX = "micronaut.security.oauth2";
    public static final boolean DEFAULT_ENABLED = true;
    private static final String DEFAULT_LOGIN = "/oauth/login{/provider}";
    private static final String DEFAULT_CALLBACK = "/oauth/callback{/provider}";
    private boolean enabled = true;
    private String callbackUri = "/oauth/callback{/provider}";
    private String loginUri = "/oauth/login{/provider}";
    private String defaultProvider = null;
    private OpenIdConfigurationProperties openid = new OpenIdConfigurationProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    @NonNull
    public String getLoginUri() {
        return this.loginUri;
    }

    public void setLoginUri(@NonNull String loginUri) {
        this.loginUri = loginUri;
    }

    @Override
    @NonNull
    public String getCallbackUri() {
        return this.callbackUri;
    }

    public void setDefaultProvider(String defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Override
    @Nullable
    public Optional<String> getDefaultProvider() {
        return Optional.ofNullable(this.defaultProvider);
    }

    public void setCallbackUri(@NonNull String callbackUri) {
        this.callbackUri = callbackUri;
    }

    @Override
    @NonNull
    public OpenIdConfiguration getOpenid() {
        return this.openid;
    }

    public void setOpenid(@NonNull OpenIdConfigurationProperties openid) {
        this.openid = openid;
    }

    @ConfigurationProperties(value="openid")
    public static class OpenIdConfigurationProperties
    implements OpenIdConfiguration {
        public static final String PREFIX = "micronaut.security.oauth2.openid";
        private static final String DEFAULT_LOGOUT = "/oauth/logout";
        private String logoutUri = "/oauth/logout";
        private EndSessionConfigurationProperties endSession = new EndSessionConfigurationProperties();
        private ClaimsValidationConfigurationProperties claimsValidation = new ClaimsValidationConfigurationProperties();
        private AdditionalClaimsConfigurationProperties additionalClaims = new AdditionalClaimsConfigurationProperties();

        @Override
        public String getLogoutUri() {
            return this.logoutUri;
        }

        public void setLogoutUri(String logoutUri) {
            this.logoutUri = logoutUri;
        }

        @Override
        public Optional<EndSessionConfiguration> getEndSession() {
            return Optional.of(this.endSession);
        }

        public void setEndSession(EndSessionConfigurationProperties endSession) {
            this.endSession = endSession;
        }

        @Override
        public ClaimsValidationConfigurationProperties getClaimsValidation() {
            return this.claimsValidation;
        }

        public void setClaimsValidation(ClaimsValidationConfigurationProperties claimsValidator) {
            this.claimsValidation = claimsValidator;
        }

        @Override
        public AdditionalClaimsConfigurationProperties getAdditionalClaims() {
            return this.additionalClaims;
        }

        public void setAdditionalClaims(AdditionalClaimsConfigurationProperties claims) {
            this.additionalClaims = claims;
        }

        @ConfigurationProperties(value="end-session")
        public static class EndSessionConfigurationProperties
        implements EndSessionConfiguration {
            private static final String DEFAULT_REDIRECT_URI = "/logout";
            private String redirectUri = "/logout";

            @Override
            @NonNull
            public String getRedirectUri() {
                return this.redirectUri;
            }

            public void setRedirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
            }
        }

        @ConfigurationProperties(value="claims-validation")
        public static class ClaimsValidationConfigurationProperties
        implements OpenIdClaimsValidationConfiguration {
            public static final String PREFIX = "micronaut.security.oauth2.openid.claims-validation";
            private static final boolean DEFAULT_ISSUER_ENABLED = true;
            private static final boolean DEFAULT_AUDIENCE_ENABLED = true;
            private static final boolean DEFAULT_AUTHORIZED_PARTY_ENABLED = true;
            private boolean issuer = true;
            private boolean audience = true;
            private boolean authorizedParty = true;

            @Override
            public boolean isIssuer() {
                return this.issuer;
            }

            public void setIssuer(boolean issuer) {
                this.issuer = issuer;
            }

            @Override
            public boolean isAudience() {
                return this.audience;
            }

            public void setAudience(boolean audience) {
                this.audience = audience;
            }

            @Override
            public boolean isAuthorizedParty() {
                return this.authorizedParty;
            }

            public void setAuthorizedParty(boolean authorizedParty) {
                this.authorizedParty = authorizedParty;
            }
        }

        @ConfigurationProperties(value="additional-claims")
        public static class AdditionalClaimsConfigurationProperties
        implements OpenIdAdditionalClaimsConfiguration {
            public static final String PREFIX = "micronaut.security.oauth2.openid.additional-claims";
            private boolean jwt;
            private boolean accessToken;
            private boolean refreshToken;

            @Override
            public boolean isJwt() {
                return this.jwt;
            }

            public void setJwt(boolean jwt) {
                this.jwt = jwt;
            }

            @Override
            public boolean isAccessToken() {
                return this.accessToken;
            }

            public void setAccessToken(boolean accessToken) {
                this.accessToken = accessToken;
            }

            @Override
            public boolean isRefreshToken() {
                return this.refreshToken;
            }

            public void setRefreshToken(boolean refreshToken) {
                this.refreshToken = refreshToken;
            }
        }
    }
}

