/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationMode;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.AbstractEndSessionRequest;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import io.micronaut.security.token.reader.TokenResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class OktaEndSessionEndpoint
extends AbstractEndSessionRequest {
    private static final String PARAM_POST_LOGOUT_REDIRECT_URI = "post_logout_redirect_uri";
    private static final String PARAM_ID_TOKEN_HINT = "id_token_hint";
    private final SecurityConfiguration securityConfiguration;
    private final TokenResolver tokenResolver;

    public OktaEndSessionEndpoint(EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> providerMetadata, SecurityConfiguration securityConfiguration, TokenResolver tokenResolver) {
        super(endSessionCallbackUrlBuilder, clientConfiguration, providerMetadata);
        this.securityConfiguration = securityConfiguration;
        this.tokenResolver = tokenResolver;
    }

    @Override
    protected String getUrl() {
        return ((OpenIdProviderMetadata)this.providerMetadataSupplier.get()).getEndSessionEndpoint();
    }

    @Override
    protected Map<String, Object> getArguments(HttpRequest<?> originating, Authentication authentication) {
        Optional<String> idToken = this.parseIdToken(originating, authentication);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        idToken.ifPresent(token -> arguments.put(PARAM_ID_TOKEN_HINT, token));
        arguments.put(PARAM_POST_LOGOUT_REDIRECT_URI, this.getRedirectUri(originating));
        return arguments;
    }

    protected Optional<String> parseIdToken(HttpRequest<?> request, Authentication authentication) {
        Map attributes = authentication.getAttributes();
        if (attributes.containsKey("openIdToken")) {
            return Optional.of(attributes.get("openIdToken").toString());
        }
        if (this.securityConfiguration.getAuthentication() == AuthenticationMode.IDTOKEN) {
            return this.tokenResolver.resolveToken(request);
        }
        return Optional.empty();
    }
}

