/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.request;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceChallenge;
import java.util.List;
import java.util.Optional;

public interface AuthorizationRequest {
    public static final String PARAMETER_SCOPE = "scope";
    public static final String PARAMETER_RESPONSE_TYPE = "response_type";
    public static final String PARAMETER_CLIENT_ID = "client_id";
    public static final String PARAMETER_REDIRECT_URI = "redirect_uri";
    public static final String PARAMETER_STATE = "state";
    public static final String PARAMETER_PKCE_CODE_CHALLENGE = "code_challenge";
    public static final String PARAMETER_PKCE_CODE_CHALLENGE_METHOD = "code_challenge_method";

    @NonNull
    public List<String> getScopes();

    @NonNull
    public String getClientId();

    public Optional<String> getState(MutableHttpResponse<?> var1);

    @NonNull
    public String getResponseType();

    public Optional<String> getRedirectUri();

    @NonNull
    default public Optional<PkceChallenge> getPkceChallenge(@NonNull MutableHttpResponse<?> response) {
        return Optional.empty();
    }
}

