/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.condition;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.utils.QualifierUtils;
import java.util.Optional;

@Internal
public abstract class AbstractCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        AnnotationMetadataProvider component = context.getComponent();
        Optional nameOptional = QualifierUtils.nameQualifier((AnnotationMetadataProvider)component);
        if (nameOptional.isEmpty()) {
            return true;
        }
        String name = (String)nameOptional.get();
        OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)context.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
        String failureMsgPrefix = this.getFailureMessagePrefix(name);
        if (clientConfiguration.isEnabled()) {
            return this.handleConfigurationEnabled(clientConfiguration, context, failureMsgPrefix);
        }
        context.fail(failureMsgPrefix + "] because the configuration is disabled");
        return false;
    }

    @NonNull
    protected abstract String getFailureMessagePrefix(@NonNull String var1);

    protected abstract boolean handleConfigurationEnabled(@NonNull OauthClientConfiguration var1, @NonNull ConditionContext<?> var2, @NonNull String var3);
}

