/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials.propagation;

import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.client.clientcredentials.propagation.ClientCredentialsHeaderTokenPropagatorConfiguration;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.utils.QualifierUtils;
import java.util.Optional;

@Internal
public class ClientCredentialsHeaderPropagatorEnabled
implements Condition {
    public boolean matches(ConditionContext context) {
        AnnotationMetadataProvider component = context.getComponent();
        Optional nameOptional = QualifierUtils.nameQualifier((AnnotationMetadataProvider)component);
        if (nameOptional.isEmpty()) {
            return true;
        }
        String name = (String)nameOptional.get();
        OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)context.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
        Optional headerTokenConfiguration = clientConfiguration.getClientCredentials().flatMap(ClientCredentialsConfiguration::getHeaderPropagation);
        if (headerTokenConfiguration.isPresent()) {
            if (((ClientCredentialsHeaderTokenPropagatorConfiguration)headerTokenConfiguration.get()).isEnabled()) {
                return true;
            }
            context.fail("Client credentials header token handler is disabled");
            return false;
        }
        context.fail("Client credentials header token handler disabled due to a lack of configuration");
        return false;
    }
}

