/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.pkce;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.CodeVerifierGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.Pkce;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.PkceGenerator;
import io.micronaut.security.oauth2.endpoint.authorization.pkce.S256PkceGenerator;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;

@Named(value="plain")
@Singleton
public class PlainPkceGenerator
implements PkceGenerator {
    public static final Integer ORDER = S256PkceGenerator.ORDER + 100;
    public static final String CODE_CHALLENGE_METHOD_PLAIN = "plain";
    private final CodeVerifierGenerator codeVerifierGenerator;

    public PlainPkceGenerator(CodeVerifierGenerator codeVerifierGenerator) {
        this.codeVerifierGenerator = codeVerifierGenerator;
    }

    @Override
    public boolean supportsAny(@NonNull List<String> codeChallengeMethods) {
        return codeChallengeMethods.stream().anyMatch(m -> m.equalsIgnoreCase(CODE_CHALLENGE_METHOD_PLAIN));
    }

    @Override
    @NonNull
    public Pkce generate() {
        String codeVerifier = this.codeVerifierGenerator.generate();
        return new Pkce(CODE_CHALLENGE_METHOD_PLAIN, codeVerifier, codeVerifier);
    }

    @NonNull
    public String getName() {
        return CODE_CHALLENGE_METHOD_PLAIN;
    }

    public int getOrder() {
        return ORDER;
    }
}

