/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignature;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfigurationProperties;

@Factory
@Internal
public class JwksUriSignatureFactory {
    @Requires(property="micronaut.security.authentication", value="idtoken")
    @EachBean(value=DefaultOpenIdProviderMetadata.class)
    public JwksSignature createJwksUriSignature(@Parameter BeanProvider<DefaultOpenIdProviderMetadata> openIdProviderMetadata, JwkValidator jwkValidator) {
        JwksSignatureConfigurationProperties jwksSignatureConfiguration = new JwksSignatureConfigurationProperties();
        jwksSignatureConfiguration.setUrl(((DefaultOpenIdProviderMetadata)openIdProviderMetadata.get()).getJwksUri());
        return new JwksSignature((JwksSignatureConfiguration)jwksSignatureConfiguration, jwkValidator);
    }
}

