/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.grants;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.authentication.AuthenticationRequest;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.grants.AsMap;
import io.micronaut.security.oauth2.grants.GrantType;
import io.micronaut.security.oauth2.grants.SecureGrant;
import io.micronaut.security.oauth2.grants.SecureGrantMap;
import java.util.Map;

@Introspected
@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
public class PasswordGrant
implements SecureGrant,
AsMap {
    private static final String KEY_GRANT_TYPE = "grant_type";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_SCOPE = "scope";
    private String grantType = GrantType.PASSWORD.toString();
    private String clientId;
    private String clientSecret;
    private String username;
    private String password;
    private String scope;

    public PasswordGrant() {
    }

    public PasswordGrant(AuthenticationRequest authenticationRequest, OauthClientConfiguration clientConfiguration) {
        this.username = authenticationRequest.getIdentity().toString();
        this.password = authenticationRequest.getSecret().toString();
        this.scope = clientConfiguration.getScopes().stream().reduce((a, b) -> a + ' ' + b).orElse(null);
    }

    @NonNull
    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(@NonNull String grantType) {
        this.grantType = grantType;
    }

    @NonNull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(@NonNull String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    @NonNull
    public String getUsername() {
        return this.username;
    }

    public void setUsername(@NonNull String username) {
        this.username = username;
    }

    @NonNull
    public String getPassword() {
        return this.password;
    }

    public void setPassword(@NonNull String password) {
        this.password = password;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(@NonNull String scope) {
        this.scope = scope;
    }

    @Override
    public Map<String, String> toMap() {
        SecureGrantMap m = new SecureGrantMap();
        m.put(KEY_GRANT_TYPE, this.grantType);
        m.put(KEY_USERNAME, this.username);
        m.put(KEY_PASSWORD, this.password);
        if (StringUtils.isNotEmpty((CharSequence)this.scope)) {
            m.put(KEY_SCOPE, this.scope);
        }
        if (this.clientId != null) {
            m.put("client_id", this.clientId);
        }
        if (this.clientSecret != null) {
            m.put("client_secret", this.clientSecret);
        }
        return m;
    }
}

