/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.token.request.password;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OauthAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdAuthenticationMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import io.micronaut.security.oauth2.grants.GrantType;
import java.util.Optional;

@Internal
public class PasswordGrantCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        Optional optional;
        AnnotationMetadataProvider component = context.getComponent();
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext && component instanceof ValueResolver && (optional = ((ValueResolver)component).get((CharSequence)Named.class.getName(), String.class)).isPresent()) {
            String name = (String)optional.get();
            OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)beanContext.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
            if (clientConfiguration.isEnabled()) {
                if (clientConfiguration.getGrantType() == GrantType.PASSWORD) {
                    if (clientConfiguration.getToken().isPresent()) {
                        if (beanContext.containsBean(OauthAuthenticationMapper.class, Qualifiers.byName((String)name))) {
                            return true;
                        }
                        context.fail("Skipped password grant flow for provider [" + name + "] because no user details mapper could be found");
                    } else if (clientConfiguration.getOpenid().isPresent()) {
                        boolean hasOpenIdProviderMetadata = beanContext.containsBean(OpenIdProviderMetadata.class, Qualifiers.byName((String)name));
                        boolean hasTokenResponseValidator = beanContext.containsBean(OpenIdTokenResponseValidator.class);
                        if (hasOpenIdProviderMetadata && hasTokenResponseValidator) {
                            boolean hasAuthenticationMapper = beanContext.containsBean(OpenIdAuthenticationMapper.class, Qualifiers.byName((String)name));
                            if (!hasAuthenticationMapper) {
                                hasAuthenticationMapper = beanContext.containsBean(DefaultOpenIdAuthenticationMapper.class);
                            }
                            if (hasAuthenticationMapper) {
                                return true;
                            }
                            context.fail("Skipped password grant flow for provider [" + name + "] because no user details mapper could be found");
                        } else {
                            context.fail("Skipped password grant flow for provider [" + name + "] because no provider metadata and token validator could be found");
                        }
                    } else {
                        context.fail("Skipped password grant flow for provider [" + name + "] because no token endpoint or openid configuration was found");
                    }
                } else {
                    context.fail("Skipped password grant flow for provider [" + name + "] because the grant type is not 'password'");
                }
            } else {
                context.fail("Skipped password grant flow for provider [" + name + "] because the configuration is disabled");
            }
            return false;
        }
        return true;
    }
}

