/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.state;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.micronaut.security.oauth2.endpoint.authorization.state.DefaultState;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JacksonStateSerDes
implements StateSerDes {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonStateSerDes.class);
    private final ObjectMapper objectMapper;

    public JacksonStateSerDes(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public State deserialize(String base64State) {
        try {
            byte[] decodedBytes = Base64.getUrlDecoder().decode(base64State);
            String state = new String(decodedBytes);
            return (State)this.objectMapper.readValue(state, DefaultState.class);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to deserialize the authorization request state", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String serialize(State state) {
        try {
            String originalInput = this.objectMapper.writeValueAsString((Object)state);
            return Base64.getEncoder().encodeToString(originalInput.getBytes());
        }
        catch (JsonProcessingException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to serialize the authorization request state to JSON", (Throwable)e);
            }
            return null;
        }
    }
}

