/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.url;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import io.micronaut.security.oauth2.configuration.OauthConfigurationProperties;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import io.micronaut.web.router.exceptions.RoutingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.inject.Singleton;

@Singleton
public class DefaultOauthRouteUrlBuilder
implements OauthRouteUrlBuilder {
    private static final String HTTP = "http";
    private final HttpHostResolver hostResolver;
    private final String loginUriTemplate;
    private final String callbackUriTemplate;

    DefaultOauthRouteUrlBuilder(HttpHostResolver hostResolver, OauthConfigurationProperties oauthConfigurationProperties) {
        this.hostResolver = hostResolver;
        this.loginUriTemplate = oauthConfigurationProperties.getLoginUri();
        this.callbackUriTemplate = oauthConfigurationProperties.getCallbackUri();
    }

    @Override
    public URL buildLoginUrl(@Nullable HttpRequest<?> originating, String providerName) {
        return this.build(originating, providerName, this.loginUriTemplate);
    }

    @Override
    public URL buildCallbackUrl(@Nullable HttpRequest<?> originating, String providerName) {
        return this.build(originating, providerName, this.callbackUriTemplate);
    }

    @Override
    public URI buildLoginUri(@Nullable String providerName) {
        try {
            return new URI(this.getPath(this.loginUriTemplate, providerName));
        }
        catch (URISyntaxException e) {
            throw new RoutingException("Error building a URI for the path [" + this.loginUriTemplate + "]", (Throwable)e);
        }
    }

    @Override
    public URI buildCallbackUri(@Nullable String providerName) {
        try {
            return new URI(this.getPath(this.callbackUriTemplate, providerName));
        }
        catch (URISyntaxException e) {
            throw new RoutingException("Error building a URI for the path [" + this.callbackUriTemplate + "]", (Throwable)e);
        }
    }

    protected URL build(@Nullable HttpRequest<?> originating, String providerName, String uriTemplate) {
        return this.buildUrl(originating, this.getPath(uriTemplate, providerName));
    }

    protected String getPath(String uriTemplate, String providerName) {
        HashMap<String, String> uriParams = new HashMap<String, String>(1);
        uriParams.put("provider", providerName);
        return UriTemplate.of((String)uriTemplate).expand(uriParams);
    }

    @Override
    public URL buildUrl(@Nullable HttpRequest<?> current, String path) {
        try {
            if (path.startsWith(HTTP)) {
                return new URL(path);
            }
            return UriBuilder.of((CharSequence)this.hostResolver.resolve(current)).path(path).build().toURL();
        }
        catch (MalformedURLException e) {
            throw new RoutingException("Error building an absolute URL for the path", (Throwable)e);
        }
    }
}

