/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials.propagation;

import io.micronaut.context.BeanContext;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.util.Toggleable;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.ClientFilterChain;
import io.micronaut.http.filter.HttpClientFilter;
import io.micronaut.http.util.OutgoingHttpRequestProcessor;
import io.micronaut.http.util.OutgointRequestProcessorMatcher;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsClient;
import io.micronaut.security.oauth2.client.clientcredentials.ClientCredentialsConfiguration;
import io.micronaut.security.oauth2.client.clientcredentials.propagation.ClientCredentialsTokenPropagator;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.token.response.TokenResponse;
import io.reactivex.Flowable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Filter(value={"/**"})
public class ClientCredentialsHttpClientFilter
implements HttpClientFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ClientCredentialsHttpClientFilter.class);
    protected final OutgoingHttpRequestProcessor outgoingHttpRequestProcessor;
    protected final List<OauthClientConfiguration> oauthClientConfigurationCollection;
    protected final BeanContext beanContext;
    protected final Map<String, ClientCredentialsClient> clientCredentialsClientsByName = new ConcurrentHashMap<String, ClientCredentialsClient>();
    protected final Map<String, ClientCredentialsTokenPropagator> clientCredentialsTokenHandlerByName = new ConcurrentHashMap<String, ClientCredentialsTokenPropagator>();
    private final Function<String, ClientCredentialsClient> clientFunction;
    private final Function<String, ClientCredentialsTokenPropagator> tokenPropagatorFunction;

    public ClientCredentialsHttpClientFilter(OutgoingHttpRequestProcessor outgoingHttpRequestProcessor, Stream<OauthClientConfiguration> oauthClientConfigurationStream, ClientCredentialsTokenPropagator defaultTokenPropagator, BeanContext beanContext) {
        this.outgoingHttpRequestProcessor = outgoingHttpRequestProcessor;
        this.oauthClientConfigurationCollection = oauthClientConfigurationStream.filter(config -> config.getClientCredentials().map(Toggleable::isEnabled).orElse(false)).collect(Collectors.toList());
        this.beanContext = beanContext;
        this.clientFunction = key -> (ClientCredentialsClient)beanContext.getBean(ClientCredentialsClient.class, Qualifiers.byName((String)key));
        this.tokenPropagatorFunction = key -> beanContext.findBean(ClientCredentialsTokenPropagator.class, Qualifiers.byName((String)key)).orElse(defaultTokenPropagator);
    }

    public Publisher<? extends HttpResponse<?>> doFilter(MutableHttpRequest<?> request, ClientFilterChain chain) {
        Optional<OauthClientConfiguration> oauthClientOptional = this.getClientConfiguration((HttpRequest<?>)request);
        if (!oauthClientOptional.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Did not find any OAuth 2.0 client which should decorate the request with an access token received from client credentials request");
            }
            return chain.proceed(request);
        }
        OauthClientConfiguration oauthClient = oauthClientOptional.get();
        Optional<ClientCredentialsClient> clientCredentialsClientOptional = this.getClient(oauthClient);
        if (!clientCredentialsClientOptional.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Could not retrieve client credentials client for OAuth 2.0 client {}", (Object)oauthClient.getName());
            }
            return chain.proceed(request);
        }
        ClientCredentialsTokenPropagator tokenHandler = this.getTokenHandler(oauthClient);
        return Flowable.fromPublisher(clientCredentialsClientOptional.get().requestToken(this.getScope(oauthClient))).map(TokenResponse::getAccessToken).switchMap(accessToken -> {
            if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                tokenHandler.writeToken(request, (String)accessToken);
            }
            return chain.proceed(request);
        });
    }

    @Nullable
    protected String getScope(@NonNull OauthClientConfiguration oauthClient) {
        return oauthClient.getClientCredentials().flatMap(ClientCredentialsConfiguration::getScope).orElse(null);
    }

    protected Optional<ClientCredentialsClient> getClient(@NonNull OauthClientConfiguration oauthClient) {
        try {
            return Optional.of(this.clientCredentialsClientsByName.computeIfAbsent(oauthClient.getName(), this.clientFunction));
        }
        catch (NoSuchBeanException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("no client credentials client for OAuth 2.0 client {}", (Object)oauthClient.getName());
            }
            return Optional.empty();
        }
    }

    protected ClientCredentialsTokenPropagator getTokenHandler(@NonNull OauthClientConfiguration oauthClient) {
        return this.clientCredentialsTokenHandlerByName.computeIfAbsent(oauthClient.getName(), this.tokenPropagatorFunction);
    }

    protected Optional<OauthClientConfiguration> getClientConfiguration(HttpRequest<?> request) {
        for (OauthClientConfiguration oauthClient : this.oauthClientConfigurationCollection) {
            ClientCredentialsConfiguration clientCredentialsConfiguration = oauthClient.getClientCredentials().get();
            if (!this.outgoingHttpRequestProcessor.shouldProcessRequest((OutgointRequestProcessorMatcher)clientCredentialsConfiguration, request)) continue;
            return Optional.of(oauthClient);
        }
        return Optional.empty();
    }
}

