/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.nonce;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.oauth2.endpoint.nonce.NonceFactory;
import io.micronaut.security.oauth2.endpoint.nonce.persistence.NoncePersistence;
import java.util.UUID;
import javax.inject.Singleton;

@Requires(beans={NoncePersistence.class})
@Singleton
public class DefaultNonceFactory
implements NonceFactory {
    private final NoncePersistence noncePersistence;

    public DefaultNonceFactory(NoncePersistence noncePersistence) {
        this.noncePersistence = noncePersistence;
    }

    @Override
    @NonNull
    public String buildNonce(HttpRequest<?> request, MutableHttpResponse response) {
        String nonce = UUID.randomUUID().toString();
        this.noncePersistence.persistNonce(request, response, nonce);
        return nonce;
    }
}

