/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import io.micronaut.context.BeanContext;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.client.OauthClient;
import io.micronaut.security.oauth2.client.condition.OauthClientCondition;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRedirectHandler;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.OauthAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationErrorResponseException;
import io.micronaut.security.oauth2.endpoint.authorization.response.AuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OauthAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OauthAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.token.response.OauthUserDetailsMapper;
import io.reactivex.Flowable;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=OauthUserDetailsMapper.class)
@Requires(condition=OauthClientCondition.class)
public class DefaultOauthClient
implements OauthClient {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOauthClient.class);
    private final OauthClientConfiguration clientConfiguration;
    private final OauthUserDetailsMapper userDetailsMapper;
    private final AuthorizationRedirectHandler redirectHandler;
    private final OauthAuthorizationResponseHandler authorizationResponseHandler;
    private final BeanContext beanContext;
    private final SecureEndpoint tokenEndpoint;

    public DefaultOauthClient(@Parameter OauthUserDetailsMapper userDetailsMapper, @Parameter OauthClientConfiguration clientConfiguration, AuthorizationRedirectHandler redirectHandler, OauthAuthorizationResponseHandler authorizationResponseHandler, BeanContext beanContext) {
        this.clientConfiguration = clientConfiguration;
        this.userDetailsMapper = userDetailsMapper;
        this.redirectHandler = redirectHandler;
        this.authorizationResponseHandler = authorizationResponseHandler;
        this.beanContext = beanContext;
        this.tokenEndpoint = this.getTokenEndpoint();
    }

    @Override
    public String getName() {
        return this.clientConfiguration.getName();
    }

    @Override
    public Publisher<MutableHttpResponse<?>> authorizationRedirect(HttpRequest<?> originating) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)this.beanContext.createBean(OauthAuthorizationRequest.class, new Object[]{originating, this.clientConfiguration});
        String authorizationEndpoint = (String)this.clientConfiguration.getAuthorization().flatMap(EndpointConfiguration::getUrl).orElseThrow(() -> new ConfigurationException("Oauth client requires the authorization URL to be set in configuration"));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Starting authorization code grant flow to provider [{}]. Redirecting to [{}]", (Object)this.getName(), (Object)authorizationEndpoint);
        }
        return Flowable.just(this.redirectHandler.redirect(authorizationRequest, authorizationEndpoint));
    }

    @Override
    public Publisher<AuthenticationResponse> onCallback(HttpRequest<Map<String, Object>> request) {
        ConvertibleMultiValues responseData = request.getBody().map(body -> {
            MutableConvertibleMultiValuesMap map = new MutableConvertibleMultiValuesMap();
            body.forEach((key, value) -> map.add((CharSequence)key, (Object)value.toString()));
            return map;
        }).orElseGet(() -> request.getParameters());
        if (this.isErrorCallback((ConvertibleMultiValues<String>)responseData)) {
            AuthorizationErrorResponse errorResponse = (AuthorizationErrorResponse)this.beanContext.createBean(AuthorizationErrorResponse.class, new Object[]{request});
            if (LOG.isTraceEnabled()) {
                LOG.trace("Received an authorization error response from provider [{}]. Error: [{}]", (Object)this.getName(), (Object)errorResponse.getError());
            }
            return Flowable.error((Throwable)new AuthorizationErrorResponseException(errorResponse));
        }
        AuthorizationResponse authorizationResponse = (AuthorizationResponse)this.beanContext.createBean(OauthAuthorizationResponse.class, new Object[]{request});
        if (LOG.isTraceEnabled()) {
            LOG.trace("Received a successful authorization response from provider [{}]", (Object)this.getName());
        }
        return this.authorizationResponseHandler.handle(authorizationResponse, this.clientConfiguration, this.userDetailsMapper, this.tokenEndpoint);
    }

    protected boolean isErrorCallback(ConvertibleMultiValues<String> responseData) {
        return responseData.contains("error");
    }

    @Deprecated
    protected SecureEndpoint getTokenEndpoint() {
        return this.clientConfiguration.getTokenEndpoint();
    }
}

