/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client;

import com.nimbusds.jose.jwk.KeyType;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.oauth2.client.DefaultOpenIdProviderMetadata;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignature;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import javax.inject.Provider;

@Factory
@Internal
public class JwksUriSignatureFactory {
    @Requires(property="micronaut.security.authentication", value="idtoken")
    @EachBean(value=DefaultOpenIdProviderMetadata.class)
    public JwksSignature createJwksUriSignature(final @Parameter Provider<DefaultOpenIdProviderMetadata> openIdProviderMetadata, JwkValidator jwkValidator) {
        return new JwksSignature(new JwksSignatureConfiguration(){

            @NonNull
            public String getUrl() {
                return ((DefaultOpenIdProviderMetadata)openIdProviderMetadata.get()).getJwksUri();
            }

            @Nullable
            public KeyType getKeyType() {
                return null;
            }
        }, jwkValidator);
    }
}

