/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.condition;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.Named;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.AuthorizationEndpointConfiguration;
import io.micronaut.security.oauth2.configuration.endpoints.EndpointConfiguration;
import io.micronaut.security.oauth2.endpoint.authorization.request.ResponseType;
import io.micronaut.security.oauth2.grants.GrantType;
import java.util.Optional;

@Internal
public class OpenIdClientCondition
implements Condition {
    public boolean matches(ConditionContext context) {
        Optional optional;
        AnnotationMetadataProvider component = context.getComponent();
        BeanContext beanContext = context.getBeanContext();
        if (beanContext instanceof ApplicationContext && component instanceof ValueResolver && (optional = ((ValueResolver)component).get((CharSequence)Named.class.getName(), String.class)).isPresent()) {
            String name = (String)optional.get();
            OauthClientConfiguration clientConfiguration = (OauthClientConfiguration)beanContext.getBean(OauthClientConfiguration.class, Qualifiers.byName((String)name));
            OpenIdClientConfiguration openIdClientConfiguration = clientConfiguration.getOpenid().get();
            if (clientConfiguration.isEnabled()) {
                if (openIdClientConfiguration.getIssuer().isPresent() || this.endpointsManuallyConfigured(openIdClientConfiguration)) {
                    if (clientConfiguration.getGrantType() == GrantType.AUTHORIZATION_CODE) {
                        Optional<AuthorizationEndpointConfiguration> authorization = openIdClientConfiguration.getAuthorization();
                        if (!authorization.isPresent() || authorization.get().getResponseType() == ResponseType.CODE) {
                            return true;
                        }
                        context.fail("Skipped OpenID client creation for provider [" + name + "] because the response type is not 'code'");
                    } else {
                        context.fail("Skipped OpenID client creation for provider [" + name + "] because the grant type is not 'authorization-code'");
                    }
                } else {
                    context.fail("Skipped OpenID client creation for provider [" + name + "] because no issuer is configured");
                }
            } else {
                context.fail("Skipped OpenID client creation for provider [" + name + "] because the configuration is disabled");
            }
            return false;
        }
        return true;
    }

    private boolean endpointsManuallyConfigured(OpenIdClientConfiguration openIdClientConfiguration) {
        return openIdClientConfiguration.getAuthorization().map(EndpointConfiguration::getUrl).isPresent() && openIdClientConfiguration.getToken().map(EndpointConfiguration::getUrl).isPresent();
    }
}

