/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.endsession.request;

import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.configuration.OpenIdClientConfiguration;
import io.micronaut.security.oauth2.endpoint.endsession.request.AbstractEndSessionRequest;
import io.micronaut.security.oauth2.endpoint.endsession.response.EndSessionCallbackUrlBuilder;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class Auth0EndSessionEndpoint
extends AbstractEndSessionRequest {
    public Auth0EndSessionEndpoint(EndSessionCallbackUrlBuilder endSessionCallbackUrlBuilder, OauthClientConfiguration clientConfiguration, Supplier<OpenIdProviderMetadata> providerMetadata) {
        super(endSessionCallbackUrlBuilder, clientConfiguration, providerMetadata);
    }

    @Override
    protected String getUrl() {
        URL url = (URL)this.clientConfiguration.getOpenid().flatMap(OpenIdClientConfiguration::getIssuer).get();
        return StringUtils.prependUri((String)url.toString(), (String)"/v2/logout");
    }

    @Override
    protected Map<String, Object> getArguments(HttpRequest<?> originating, Authentication authentication) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("client_id", this.clientConfiguration.getClientId());
        arguments.put("returnTo", this.getRedirectUri(originating));
        return arguments;
    }
}

