/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.state;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.state.DefaultState;
import io.micronaut.security.oauth2.endpoint.authorization.state.MutableState;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateFactory;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import io.micronaut.security.oauth2.endpoint.authorization.state.persistence.StatePersistence;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
@Requires(beans={StatePersistence.class})
public class DefaultStateFactory
implements StateFactory {
    private final StateSerDes stateSerDes;
    private final StatePersistence statePersistence;

    public DefaultStateFactory(StateSerDes stateSerDes, StatePersistence statePersistence) {
        this.stateSerDes = stateSerDes;
        this.statePersistence = statePersistence;
    }

    @Override
    @Nullable
    public String buildState(HttpRequest<?> request, MutableHttpResponse response, @Nullable AuthorizationRequest authorizationRequest) {
        Optional rejectedStatus = request.getAttribute(SecurityFilter.REJECTION, HttpStatus.class);
        MutableState state = this.createInitialState();
        rejectedStatus.filter(status -> status.equals((Object)HttpStatus.UNAUTHORIZED)).ifPresent(status -> state.setOriginalUri(request.getUri()));
        Optional.ofNullable(authorizationRequest).flatMap(AuthorizationRequest::getRedirectUri).map(UriBuilder::of).map(UriBuilder::build).ifPresent(state::setRedirectUri);
        this.statePersistence.persistState(request, response, state);
        return this.stateSerDes.serialize(state);
    }

    protected MutableState createInitialState() {
        return new DefaultState();
    }
}

