/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import com.nimbusds.jwt.JWT;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requires;
import io.micronaut.security.authentication.AuthenticationException;
import io.micronaut.security.authentication.AuthenticationFailed;
import io.micronaut.security.authentication.AuthenticationResponse;
import io.micronaut.security.oauth2.client.OpenIdProviderMetadata;
import io.micronaut.security.oauth2.configuration.OauthClientConfiguration;
import io.micronaut.security.oauth2.endpoint.SecureEndpoint;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OpenIdAuthorizationResponseHandler;
import io.micronaut.security.oauth2.endpoint.authorization.state.InvalidStateException;
import io.micronaut.security.oauth2.endpoint.authorization.state.State;
import io.micronaut.security.oauth2.endpoint.authorization.state.validation.StateValidator;
import io.micronaut.security.oauth2.endpoint.token.request.TokenEndpointClient;
import io.micronaut.security.oauth2.endpoint.token.request.context.OpenIdCodeTokenRequestContext;
import io.micronaut.security.oauth2.endpoint.token.response.DefaultOpenIdUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.JWTOpenIdClaims;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdTokenResponse;
import io.micronaut.security.oauth2.endpoint.token.response.OpenIdUserDetailsMapper;
import io.micronaut.security.oauth2.endpoint.token.response.validation.OpenIdTokenResponseValidator;
import io.micronaut.security.oauth2.url.OauthRouteUrlBuilder;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import java.text.ParseException;
import java.util.Optional;
import javax.inject.Singleton;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(configuration="io.micronaut.security.token.jwt")
public class DefaultOpenIdAuthorizationResponseHandler
implements OpenIdAuthorizationResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultOpenIdAuthorizationResponseHandler.class);
    private final OpenIdTokenResponseValidator tokenResponseValidator;
    private final OpenIdUserDetailsMapper defaultUserDetailsMapper;
    private final TokenEndpointClient tokenEndpointClient;
    private final OauthRouteUrlBuilder oauthRouteUrlBuilder;
    @Nullable
    private final StateValidator stateValidator;

    public DefaultOpenIdAuthorizationResponseHandler(OpenIdTokenResponseValidator tokenResponseValidator, DefaultOpenIdUserDetailsMapper userDetailsMapper, TokenEndpointClient tokenEndpointClient, OauthRouteUrlBuilder oauthRouteUrlBuilder, @Nullable StateValidator stateValidator) {
        this.tokenResponseValidator = tokenResponseValidator;
        this.defaultUserDetailsMapper = userDetailsMapper;
        this.tokenEndpointClient = tokenEndpointClient;
        this.oauthRouteUrlBuilder = oauthRouteUrlBuilder;
        this.stateValidator = stateValidator;
    }

    @Override
    public Publisher<AuthenticationResponse> handle(OpenIdAuthorizationResponse authorizationResponse, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, @Nullable OpenIdUserDetailsMapper userDetailsMapper, SecureEndpoint tokenEndpoint) {
        try {
            this.validateState(authorizationResponse, clientConfiguration);
        }
        catch (InvalidStateException e) {
            return Flowable.just((Object)new AuthenticationFailed("State validation failed: " + e.getMessage()));
        }
        return Flowable.fromPublisher(this.sendRequest(authorizationResponse, clientConfiguration, tokenEndpoint)).switchMap(response -> this.createAuthenticationResponse(authorizationResponse.getNonce(), clientConfiguration, openIdProviderMetadata, (OpenIdTokenResponse)response, userDetailsMapper, authorizationResponse.getState()));
    }

    private void validateState(OpenIdAuthorizationResponse authorizationResponse, OauthClientConfiguration clientConfiguration) throws InvalidStateException {
        if (this.stateValidator != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Validating state found in the authorization response from provider [{}]", (Object)clientConfiguration.getName());
            }
            State state = authorizationResponse.getState();
            this.stateValidator.validate(authorizationResponse.getCallbackRequest(), state);
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Skipping state validation, no state validator found");
        }
    }

    private Publisher<OpenIdTokenResponse> sendRequest(OpenIdAuthorizationResponse authorizationResponse, OauthClientConfiguration clientConfiguration, SecureEndpoint tokenEndpoint) {
        OpenIdCodeTokenRequestContext requestContext = new OpenIdCodeTokenRequestContext(authorizationResponse, this.oauthRouteUrlBuilder, tokenEndpoint, clientConfiguration);
        return this.tokenEndpointClient.sendRequest(requestContext);
    }

    private Flowable<AuthenticationResponse> createAuthenticationResponse(String nonce, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, OpenIdTokenResponse openIdTokenResponse, @Nullable OpenIdUserDetailsMapper userDetailsMapper, @Nullable State state) {
        return Flowable.create(emitter -> {
            try {
                Optional<AuthenticationResponse> authenticationResponse = this.validateOpenIdTokenResponse(nonce, clientConfiguration, openIdProviderMetadata, openIdTokenResponse, userDetailsMapper, state);
                if (authenticationResponse.isPresent()) {
                    emitter.onNext((Object)authenticationResponse.get());
                    emitter.onComplete();
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Token validation failed. Failing authentication");
                    }
                    emitter.onError((Throwable)new AuthenticationException((AuthenticationResponse)new AuthenticationFailed("JWT validation failed")));
                }
            }
            catch (ParseException e) {
                emitter.onError((Throwable)e);
            }
        }, (BackpressureStrategy)BackpressureStrategy.ERROR);
    }

    private Optional<AuthenticationResponse> validateOpenIdTokenResponse(String nonce, OauthClientConfiguration clientConfiguration, OpenIdProviderMetadata openIdProviderMetadata, OpenIdTokenResponse openIdTokenResponse, @Nullable OpenIdUserDetailsMapper userDetailsMapper, @Nullable State state) throws ParseException {
        Optional<JWT> jwt;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Token endpoint returned a success response. Validating the JWT");
        }
        if ((jwt = this.tokenResponseValidator.validate(clientConfiguration, openIdProviderMetadata, openIdTokenResponse, nonce)).isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Token validation succeeded. Creating a user details");
            }
            JWTOpenIdClaims claims = new JWTOpenIdClaims(jwt.get().getJWTClaimsSet());
            OpenIdUserDetailsMapper openIdUserDetailsMapper = userDetailsMapper != null ? userDetailsMapper : this.defaultUserDetailsMapper;
            return Optional.of(openIdUserDetailsMapper.createAuthenticationResponse(clientConfiguration.getName(), openIdTokenResponse, claims, state));
        }
        return Optional.empty();
    }
}

