/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.client.clientcredentials;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.annotation.Internal;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Processor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
class CacheableProcessor<T>
implements Processor<T, T> {
    @Nullable
    private T element;
    @Nullable
    private Throwable throwable;
    private boolean complete;
    @Nullable
    private Subscription subscription;
    @NonNull
    private Queue<ElementSubscription<T>> subscriptions = new ConcurrentLinkedQueue<ElementSubscription<T>>();
    @Nullable
    private final Function<T, T> transformer;

    CacheableProcessor() {
        this.transformer = null;
    }

    CacheableProcessor(@NonNull Function<T, T> transformer) {
        this.transformer = transformer;
    }

    public void clear() {
        this.complete = false;
        this.element = null;
        this.throwable = null;
        if (this.subscription != null) {
            this.subscription.cancel();
            this.subscription = null;
        }
        this.subscriptions = this.subscriptions.stream().filter(elementSubscription -> !elementSubscription.isCanceled() && !elementSubscription.isComplete()).collect(Collectors.toCollection(ConcurrentLinkedQueue::new));
    }

    public void onSubscribe(Subscription s) {
        this.subscription = s;
    }

    public void onNext(T el) {
        this.element = this.transformer != null ? this.transformer.apply(el) : el;
        this.flowData();
    }

    public void onError(Throwable t) {
        this.throwable = t;
        this.flowData();
    }

    public void onComplete() {
        this.complete = true;
    }

    public void subscribe(Subscriber<? super T> s) {
        ElementSubscription<? super T> subscription = new ElementSubscription<T>(s, this);
        this.subscriptions.add(subscription);
        s.onSubscribe(subscription);
    }

    public void onElementsRequested() {
        if (this.element == null && this.subscription != null) {
            this.subscription.request(1L);
        } else {
            this.flowData();
        }
    }

    private void flowData() {
        for (ElementSubscription elementSubscription : this.subscriptions) {
            if (elementSubscription.isCanceled() || elementSubscription.isComplete()) continue;
            if (this.element != null) {
                if (!elementSubscription.isElementsRequested()) continue;
                elementSubscription.getSubscriber().onNext(this.element);
                elementSubscription.setElementsRequested(false);
                if (!this.complete) continue;
                elementSubscription.getSubscriber().onComplete();
                elementSubscription.setComplete(true);
                continue;
            }
            if (this.throwable == null) continue;
            elementSubscription.getSubscriber().onError(this.throwable);
        }
    }

    @Nullable
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Nullable
    public T getElement() {
        return this.element;
    }

    private static class ElementSubscription<T>
    implements Subscription {
        private final Subscriber<? super T> subscriber;
        private final CacheableProcessor<T> listener;
        private boolean canceled;
        private boolean elementsRequested;
        private boolean complete;

        public ElementSubscription(Subscriber<? super T> subscriber, CacheableProcessor<T> listener) {
            this.subscriber = subscriber;
            this.listener = listener;
        }

        public void setElementsRequested(boolean elementsRequested) {
            this.elementsRequested = elementsRequested;
        }

        public boolean isElementsRequested() {
            return this.elementsRequested;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public boolean isComplete() {
            return this.complete;
        }

        public void setComplete(boolean complete) {
            this.complete = complete;
        }

        public Subscriber<? super T> getSubscriber() {
            return this.subscriber;
        }

        public void cancel() {
            this.canceled = true;
        }

        public void request(long n) {
            if (n > 0L) {
                this.elementsRequested = true;
                this.listener.onElementsRequested();
            }
        }
    }
}

