/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.request;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRedirectHandler;
import io.micronaut.security.oauth2.endpoint.authorization.request.AuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.OpenIdAuthorizationRequest;
import io.micronaut.security.oauth2.endpoint.authorization.request.OpenIdScope;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultAuthorizationRedirectHandler
implements AuthorizationRedirectHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationRedirectHandler.class);

    public MutableHttpResponse redirect(AuthorizationRequest authorizationRequest, String authorizationEndpoint) {
        MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.FOUND);
        Map<String, Object> arguments = this.instantiateParameters(authorizationRequest, response);
        String expandedUri = this.expandedUri(authorizationEndpoint, arguments);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Built the authorization URL [{}]", (Object)expandedUri);
        }
        return response.header((CharSequence)"Location", (CharSequence)expandedUri);
    }

    protected String expandedUri(@NonNull String baseUrl, @NonNull Map<String, Object> queryParams) {
        UriBuilder builder = UriBuilder.of((CharSequence)baseUrl);
        for (String k : queryParams.keySet()) {
            Object val = queryParams.get(k);
            if (val == null) continue;
            builder.queryParam(k, new Object[]{val});
        }
        return builder.toString();
    }

    protected Map<String, Object> instantiateParameters(AuthorizationRequest authorizationRequest, MutableHttpResponse response) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.populateScope(authorizationRequest, parameters);
        this.populateResponseType(authorizationRequest, parameters);
        this.populateClientId(authorizationRequest, parameters);
        this.populateRedirectUri(authorizationRequest, parameters);
        this.populateState(authorizationRequest, parameters, response);
        if (authorizationRequest instanceof OpenIdAuthorizationRequest) {
            OpenIdAuthorizationRequest openIdAuthorizationRequest = (OpenIdAuthorizationRequest)authorizationRequest;
            this.populateResponseMode(openIdAuthorizationRequest, parameters);
            this.populateNonce(openIdAuthorizationRequest, parameters, response);
            this.populateDisplay(openIdAuthorizationRequest, parameters);
            this.populatePrompt(openIdAuthorizationRequest, parameters);
            this.populateMaxAge(openIdAuthorizationRequest, parameters);
            this.populateUiLocales(openIdAuthorizationRequest, parameters);
            this.populateIdTokenHint(openIdAuthorizationRequest, parameters);
            this.populateLoginHint(openIdAuthorizationRequest, parameters);
            this.populateAcrValues(openIdAuthorizationRequest, parameters);
        }
        return parameters;
    }

    protected void populateScope(@NonNull AuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        String defaultScope;
        Optional optionalScope = authorizationRequest.getScopes().stream().reduce((a, b) -> a + ' ' + b);
        String scope = optionalScope.orElse(defaultScope = authorizationRequest instanceof OpenIdAuthorizationRequest ? OpenIdScope.OPENID.toString() : null);
        if (scope != null) {
            parameters.put("scope", scope);
        }
    }

    protected void populateResponseType(@NonNull AuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        parameters.put("response_type", authorizationRequest.getResponseType());
    }

    protected void populateClientId(@NonNull AuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        parameters.put("client_id", authorizationRequest.getClientId());
    }

    protected void populateRedirectUri(@NonNull AuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getRedirectUri().ifPresent(uri -> parameters.put("redirect_uri", uri));
    }

    protected void populateState(@NonNull AuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters, @NonNull MutableHttpResponse response) {
        authorizationRequest.getState(response).ifPresent(state -> parameters.put("state", state));
    }

    protected void populateResponseMode(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getResponseMode().ifPresent(rm -> parameters.put("response_mode", rm));
    }

    protected void populateNonce(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters, @NonNull MutableHttpResponse response) {
        authorizationRequest.getNonce(response).ifPresent(nonce -> parameters.put("nonce", nonce));
    }

    protected void populateDisplay(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getDisplay().ifPresent(display -> parameters.put("display", display));
    }

    protected void populatePrompt(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getPrompt().ifPresent(prompt -> parameters.put("prompt", prompt));
    }

    protected void populateMaxAge(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getMaxAge().ifPresent(maxAge -> parameters.put("max_age", maxAge));
    }

    protected void populateUiLocales(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getUiLocales().flatMap(uiLocales -> uiLocales.stream().reduce((a, b) -> a + ' ' + b)).ifPresent(uiLocales -> parameters.put("ui_locales", uiLocales));
    }

    protected void populateIdTokenHint(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getIdTokenHint().ifPresent(idTokenHint -> parameters.put("id_token_hint", idTokenHint));
    }

    protected void populateLoginHint(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getLoginHint().ifPresent(loginHint -> parameters.put("login_hint", loginHint));
    }

    protected void populateAcrValues(@NonNull OpenIdAuthorizationRequest authorizationRequest, @NonNull Map<String, Object> parameters) {
        authorizationRequest.getAcrValues().flatMap(acrValues -> acrValues.stream().reduce((a, b) -> a + ' ' + b)).ifPresent(acrValues -> parameters.put("acr_values", acrValues));
    }
}

