/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.nonce.persistence.cookie;

import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.oauth2.endpoint.nonce.persistence.NoncePersistence;
import io.micronaut.security.oauth2.endpoint.nonce.persistence.cookie.CookieNoncePersistenceConfiguration;
import java.util.Optional;

public class CookieNoncePersistence
implements NoncePersistence {
    private final CookieNoncePersistenceConfiguration configuration;

    public CookieNoncePersistence(CookieNoncePersistenceConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Optional<String> retrieveNonce(HttpRequest<?> request) {
        Cookie cookie = request.getCookies().get((CharSequence)this.configuration.getCookieName());
        return Optional.ofNullable(cookie).map(Cookie::getValue);
    }

    @Override
    public void persistNonce(HttpRequest<?> request, MutableHttpResponse response, String nonce) {
        Cookie cookie = Cookie.of((String)this.configuration.getCookieName(), (String)nonce);
        cookie.configure((CookieConfiguration)this.configuration, request.isSecure());
        response.cookie(cookie);
    }
}

