/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.oauth2.endpoint.authorization.response;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.core.convert.value.ConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.oauth2.endpoint.authorization.response.AbstractAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.response.OauthAuthorizationResponse;
import io.micronaut.security.oauth2.endpoint.authorization.state.StateSerDes;
import java.util.Map;
import java.util.Objects;

@Prototype
public class DefaultOauthAuthorizationResponse
extends AbstractAuthorizationResponse
implements OauthAuthorizationResponse {
    private final ConvertibleMultiValues<String> responseData;
    private final HttpRequest<Map<String, Object>> request;

    public DefaultOauthAuthorizationResponse(@Parameter HttpRequest<Map<String, Object>> request, StateSerDes stateSerDes) {
        super(request, stateSerDes);
        this.responseData = request.getBody().map(body -> {
            MutableConvertibleMultiValuesMap map = new MutableConvertibleMultiValuesMap();
            body.forEach((key, value) -> map.add((CharSequence)key, (Object)value.toString()));
            return map;
        }).orElseGet(() -> request.getParameters());
        this.request = request;
    }

    @Override
    protected String getStateValue() {
        return (String)this.responseData.get((CharSequence)"state");
    }

    @Override
    @NonNull
    public String getCode() {
        return (String)Objects.requireNonNull(this.responseData.get((CharSequence)"code"));
    }

    @Override
    @NonNull
    public HttpRequest<?> getCallbackRequest() {
        return this.request;
    }
}

