/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.ldap.context;

import io.micronaut.security.ldap.configuration.LdapConfiguration;
import io.micronaut.security.ldap.context.ContextSettings;
import java.util.Map;

public class ContextConfigurationContextSettings
implements ContextSettings {
    private final LdapConfiguration.ContextConfiguration contextConfiguration;
    private final String dn;
    private final String password;
    private final boolean pooled;

    public ContextConfigurationContextSettings(LdapConfiguration configuration) {
        this.contextConfiguration = configuration.getContext();
        this.dn = this.contextConfiguration.getManagerDn();
        this.password = this.contextConfiguration.getManagerPassword();
        this.pooled = true;
    }

    public ContextConfigurationContextSettings(LdapConfiguration configuration, String dn, String password) {
        this.contextConfiguration = configuration.getContext();
        this.dn = dn;
        this.password = password;
        this.pooled = false;
    }

    @Override
    public boolean getPooled() {
        return this.pooled;
    }

    @Override
    public String getFactory() {
        return this.contextConfiguration.getFactory();
    }

    @Override
    public String getUrl() {
        return this.contextConfiguration.getServer();
    }

    @Override
    public String getDn() {
        return this.dn;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.contextConfiguration.getProperties();
    }
}

