/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.jwk.JWKSet;
import io.micronaut.core.annotation.Blocking;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.optim.StaticOptimizations;
import io.micronaut.security.token.jwt.signature.jwks.JwkSetFetcher;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJwkSetFetcher
implements JwkSetFetcher<JWKSet> {
    public static final Optimizations OPTIMIZATIONS = StaticOptimizations.get(Optimizations.class).orElse(new Optimizations(Collections.emptyMap()));
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwkSetFetcher.class);

    @Override
    @NonNull
    @Blocking
    public Optional<JWKSet> fetch(@Nullable String url) {
        if (url == null) {
            return Optional.empty();
        }
        return OPTIMIZATIONS.findJwkSet(url).map(s -> Optional.of((JWKSet)s.get())).orElseGet(() -> Optional.ofNullable(this.load(url)));
    }

    @Override
    public void clearCache(@NonNull String url) {
        OPTIMIZATIONS.clear(url);
    }

    @Nullable
    private JWKSet load(@NonNull String url) {
        try {
            return JWKSet.load((URL)new URL(url));
        }
        catch (IOException | ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Exception loading JWK from " + url, (Throwable)e);
            }
            return null;
        }
    }

    public static class Optimizations {
        private final Map<String, Supplier<JWKSet>> suppliers;

        public Optimizations(@NonNull Map<String, Supplier<JWKSet>> suppliers) {
            this.suppliers = suppliers;
        }

        public Optional<Supplier<JWKSet>> findJwkSet(@NonNull String url) {
            return Optional.ofNullable(this.suppliers.get(url));
        }

        public void clear(@NonNull String url) {
            this.suppliers.remove(url);
        }
    }
}

