/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import com.nimbusds.jose.JWSAlgorithm;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.jwt.generator.RefreshTokenConfiguration;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

@Introspected
@Requirements(value={@Requires(property="micronaut.security.token.jwt.generator.refresh-token.secret"), @Requires(property="micronaut.security.token.jwt.generator.refresh-token.enabled", notEquals="false")})
@ConfigurationProperties(value="micronaut.security.token.jwt.generator.refresh-token")
public class RefreshTokenConfigurationProperties
implements RefreshTokenConfiguration {
    public static final String PREFIX = "micronaut.security.token.jwt.generator.refresh-token";
    public static final JWSAlgorithm DEFAULT_JWS_ALGORITHM = JWSAlgorithm.HS256;
    public static final boolean DEFAULT_BASE64 = false;
    public static final boolean DEFAULT_ENABLED = true;
    private boolean enabled = true;
    @NonNull
    @NotNull
    private JWSAlgorithm jwsAlgorithm = DEFAULT_JWS_ALGORITHM;
    @NonNull
    @NotBlank
    private String secret;
    private boolean base64 = false;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setJwsAlgorithm(@NonNull JWSAlgorithm jwsAlgorithm) {
        this.jwsAlgorithm = jwsAlgorithm;
    }

    public void setSecret(@NonNull String secret) {
        this.secret = secret;
    }

    public void setBase64(boolean base64) {
        this.base64 = base64;
    }

    @Override
    @NonNull
    public JWSAlgorithm getJwsAlgorithm() {
        return this.jwsAlgorithm;
    }

    @Override
    @NonNull
    public String getSecret() {
        return this.secret;
    }

    @Override
    public boolean isBase64() {
        return this.base64;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

