/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.ECDSAVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.util.functional.ThrowingFunction;
import io.micronaut.core.util.functional.ThrowingSupplier;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import jakarta.inject.Singleton;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultJwkValidator
implements JwkValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJwkValidator.class);

    @Override
    public boolean validate(SignedJWT jwt, JWK jwk) {
        block3: {
            Optional<JWSVerifier> verifier = this.getVerifier(jwk);
            if (verifier.isPresent()) {
                try {
                    return jwt.verify(verifier.get());
                }
                catch (JOSEException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug("JOSEException when verifying jwt", (Throwable)e);
                }
            }
        }
        return false;
    }

    protected Optional<JWSVerifier> getVerifier(JWK jwk) {
        if (jwk instanceof RSAKey) {
            RSAKey rsaKey = (RSAKey)jwk;
            return this.getVerifier(() -> ((RSAKey)rsaKey).toRSAPublicKey(), RSASSAVerifier::new);
        }
        if (jwk instanceof ECKey) {
            ECKey ecKey = (ECKey)jwk;
            return this.getVerifier(() -> ((ECKey)ecKey).toECPublicKey(), ECDSAVerifier::new);
        }
        return Optional.empty();
    }

    private <T, R extends JWSVerifier> Optional<R> getVerifier(ThrowingSupplier<T, JOSEException> supplier, ThrowingFunction<T, R, JOSEException> consumer) {
        block6: {
            Object publicKey;
            block5: {
                publicKey = null;
                try {
                    publicKey = supplier.get();
                }
                catch (JOSEException e) {
                    if (!LOG.isErrorEnabled()) break block5;
                    LOG.error("JOSEException when retrieving public key", (Throwable)e);
                }
            }
            if (publicKey != null) {
                try {
                    return Optional.of(consumer.apply(publicKey));
                }
                catch (JOSEException e) {
                    if (!LOG.isErrorEnabled()) break block6;
                    LOG.error("JOSEException when instantiating the verifier", (Throwable)e);
                }
            }
        }
        return Optional.empty();
    }
}

