/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.token.jwt.cookie.RefreshTokenCookieConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@Requirements(value={@Requires(condition=CookieBasedAuthenticationModeCondition.class), @Requires(property="micronaut.security.token.refresh.cookie.enabled", notEquals="false", defaultValue="true")})
@ConfigurationProperties(value="micronaut.security.token.refresh.cookie")
public class RefreshTokenCookieConfigurationProperties
implements RefreshTokenCookieConfiguration {
    public static final String PREFIX = "micronaut.security.token.refresh.cookie";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_HTTPONLY = true;
    public static final String DEFAULT_COOKIENAME = "JWT_REFRESH_TOKEN";
    public static final String DEFAULT_COOKIEPATH = "/oauth/access_token";
    public static final SameSite DEFAULT_COOKIESAMESITE = null;
    private String cookieDomain;
    private String cookiePath = "/oauth/access_token";
    private Boolean cookieHttpOnly = true;
    private Boolean cookieSecure;
    private Duration cookieMaxAge;
    private SameSite cookieSameSite = DEFAULT_COOKIESAMESITE;
    private boolean enabled = true;
    private String cookieName = "JWT_REFRESH_TOKEN";

    public RefreshTokenCookieConfigurationProperties(@Nullable @Property(name="micronaut.security.endpoints.oauth.path") String oauthControllerPath) {
        if (oauthControllerPath != null) {
            this.cookiePath = oauthControllerPath;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.cookieDomain);
    }

    @Nullable
    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public Optional<SameSite> getCookieSameSite() {
        return Optional.ofNullable(this.cookieSameSite);
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void setCookieSameSite(@Nullable SameSite cookieSameSite) {
        this.cookieSameSite = cookieSameSite;
    }
}

