/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.encryption.ec;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.crypto.ECDHDecrypter;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.jwt.encryption.AbstractEncryptionConfiguration;
import io.micronaut.security.token.jwt.encryption.ec.ECEncryptionConfiguration;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class ECEncryption
extends AbstractEncryptionConfiguration {
    private ECPublicKey publicKey;
    private ECPrivateKey privateKey;

    public ECEncryption(ECEncryptionConfiguration ecEncryptionConfiguration) {
        this.method = ecEncryptionConfiguration.getEncryptionMethod();
        this.algorithm = ecEncryptionConfiguration.getJweAlgorithm();
        this.publicKey = ecEncryptionConfiguration.getPublicKey();
        this.privateKey = ecEncryptionConfiguration.getPrivateKey();
    }

    @Override
    public boolean supports(JWEAlgorithm algorithm, EncryptionMethod method) {
        if (algorithm != null && method != null) {
            return ECDHDecrypter.SUPPORTED_ALGORITHMS.contains(algorithm) && ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS.contains(method);
        }
        return false;
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return "Only Elliptic-curve algorithms are supported with the appropriate encryption method";
    }

    @Override
    protected JWEEncrypter buildEncrypter() throws JOSEException {
        return this.buildEncrypterWithPublicKey(this.publicKey);
    }

    protected JWEEncrypter buildEncrypterWithPublicKey(@NonNull ECPublicKey publicKey) throws JOSEException {
        return new ECDHEncrypter(publicKey);
    }

    @Override
    protected JWEDecrypter buildDecrypter() throws JOSEException {
        return this.buildDecrypterWithPrivateKey(this.privateKey);
    }

    private JWEDecrypter buildDecrypterWithPrivateKey(ECPrivateKey privateKey) throws JOSEException {
        return new ECDHDecrypter(privateKey);
    }
}

