/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.converters;

import com.nimbusds.jose.EncryptionMethod;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class EncryptionMethodConverter
implements TypeConverter<CharSequence, EncryptionMethod> {
    public Optional<EncryptionMethod> convert(CharSequence object, Class<EncryptionMethod> targetType, ConversionContext context) {
        if (object == null) {
            return Optional.empty();
        }
        String value = object.toString();
        EncryptionMethod encryptionMethod = EncryptionMethod.parse((String)value);
        if (encryptionMethod.cekBitLength() == 0) {
            return Optional.empty();
        }
        return Optional.of(encryptionMethod);
    }
}

