/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.cookie;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.security.authentication.CookieBasedAuthenticationModeCondition;
import io.micronaut.security.config.RedirectConfigurationProperties;
import io.micronaut.security.token.jwt.cookie.JwtCookieConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@Requirements(value={@Requires(condition=CookieBasedAuthenticationModeCondition.class), @Requires(property="micronaut.security.token.jwt.cookie.enabled", notEquals="false", defaultValue="true")})
@ConfigurationProperties(value="micronaut.security.token.jwt.cookie")
public class JwtCookieConfigurationProperties
implements JwtCookieConfiguration {
    public static final String PREFIX = "micronaut.security.token.jwt.cookie";
    public static final boolean DEFAULT_ENABLED = true;
    public static final boolean DEFAULT_SECURE = true;
    public static final boolean DEFAULT_HTTPONLY = true;
    public static final String DEFAULT_COOKIENAME = "JWT";
    public static final String DEFAULT_COOKIEPATH = "/";
    public static final SameSite DEFAULT_COOKIESAMESITE = null;
    private final RedirectConfigurationProperties redirectConfiguration;
    private final PropertyResolver propertyResolver;
    private String cookieDomain;
    private String cookiePath = "/";
    private Boolean cookieHttpOnly = true;
    private Boolean cookieSecure = true;
    private Duration cookieMaxAge;
    private SameSite cookieSameSite = DEFAULT_COOKIESAMESITE;
    private boolean enabled = true;
    private String cookieName = "JWT";

    public JwtCookieConfigurationProperties(RedirectConfigurationProperties redirectConfiguration, PropertyResolver propertyResolver) {
        this.redirectConfiguration = redirectConfiguration;
        this.propertyResolver = propertyResolver;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Deprecated
    public String getLogoutTargetUrl() {
        return this.redirectConfiguration.getLogout();
    }

    @Override
    @Deprecated
    public String getLoginSuccessTargetUrl() {
        return this.redirectConfiguration.getLoginSuccess();
    }

    @Override
    @Deprecated
    public String getLoginFailureTargetUrl() {
        return this.redirectConfiguration.getLoginFailure();
    }

    @Deprecated
    public void setLogoutTargetUrl(String logoutTargetUrl) {
        if (!this.propertyResolver.containsProperty("micronaut.security.redirect.logout") && StringUtils.isNotEmpty((CharSequence)logoutTargetUrl)) {
            this.redirectConfiguration.setLogout(logoutTargetUrl);
        }
    }

    @Deprecated
    public void setLoginSuccessTargetUrl(String loginSuccessTargetUrl) {
        if (!this.propertyResolver.containsProperty("micronaut.security.redirect.login-success") && StringUtils.isNotEmpty((CharSequence)loginSuccessTargetUrl)) {
            this.redirectConfiguration.setLoginSuccess(loginSuccessTargetUrl);
        }
    }

    @Deprecated
    public void setLoginFailureTargetUrl(String loginFailureTargetUrl) {
        if (!this.propertyResolver.containsProperty("micronaut.security.redirect.login-failure") && StringUtils.isNotEmpty((CharSequence)loginFailureTargetUrl)) {
            this.redirectConfiguration.setLoginFailure(loginFailureTargetUrl);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.cookieDomain);
    }

    @Nullable
    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public Optional<SameSite> getCookieSameSite() {
        return Optional.ofNullable(this.cookieSameSite);
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public void setCookieSameSite(@Nullable SameSite cookieSameSite) {
        this.cookieSameSite = cookieSameSite;
    }
}

