/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWTClaimsSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JWTClaimsSetUtils;
import java.util.Date;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.security.token.jwt.claims-validators.not-before", value="true")
public class NotBeforeJwtClaimsValidator
implements GenericJwtClaimsValidator {
    public static final String NOT_BEFORE_PROP = "micronaut.security.token.jwt.claims-validators.not-before";
    private static final Logger LOG = LoggerFactory.getLogger(NotBeforeJwtClaimsValidator.class);

    protected boolean validate(@NonNull JWTClaimsSet claimsSet) {
        Date notBefore = claimsSet.getNotBeforeTime();
        if (notBefore == null) {
            return true;
        }
        Date now = new Date();
        if (now.before(notBefore)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Invalidating JWT not-before Claim because current time ({}) is before ({}).", (Object)now, (Object)notBefore);
            }
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean validate(JwtClaims claims) {
        return this.validate(claims, null);
    }

    @Override
    public boolean validate(@NonNull JwtClaims claims, @Nullable HttpRequest<?> request) {
        return this.validate(JWTClaimsSetUtils.jwtClaimsSetFromClaims(claims));
    }
}

