/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.jwks;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.signature.jwks.JwkValidator;
import io.micronaut.security.token.jwt.signature.jwks.JwksSignatureConfiguration;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EachBean(value=JwksSignatureConfiguration.class)
public class JwksSignature
implements SignatureConfiguration {
    public static final int DEFAULT_REFRESH_JWKS_ATTEMPTS = 1;
    private static final Logger LOG = LoggerFactory.getLogger(JwksSignature.class);
    private final JwkValidator jwkValidator;
    private JWKSet jwkSet;
    private final KeyType keyType;
    private final String url;

    @Inject
    public JwksSignature(JwksSignatureConfiguration jwksSignatureConfiguration, JwkValidator jwkValidator) {
        this(jwksSignatureConfiguration.getUrl(), jwksSignatureConfiguration.getKeyType(), jwkValidator);
    }

    public JwksSignature(String url, @Nullable KeyType keyType, JwkValidator jwkValidator) {
        this.url = url;
        if (LOG.isDebugEnabled()) {
            LOG.debug("JWT validation URL: {}", (Object)url);
        }
        this.keyType = keyType;
        this.jwkValidator = jwkValidator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<JWKSet> getJWKSet() {
        JWKSet jwkSet = this.jwkSet;
        if (jwkSet == null) {
            JwksSignature jwksSignature = this;
            synchronized (jwksSignature) {
                jwkSet = this.jwkSet;
                if (jwkSet == null) {
                    this.jwkSet = jwkSet = this.loadJwkSet(this.getUrl());
                }
            }
        }
        return Optional.ofNullable(jwkSet);
    }

    private List<JWK> getJsonWebKeys() {
        return this.getJWKSet().map(JWKSet::getKeys).orElse(Collections.emptyList());
    }

    @Override
    public String supportedAlgorithmsMessage() {
        String message = this.getJsonWebKeys().stream().map(JWK::getAlgorithm).map(Algorithm::getName).reduce((a, b) -> a + ", " + b).map(s -> "Only the " + s).orElse("No");
        return message + " algorithms are supported";
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return this.getJsonWebKeys().stream().map(JWK::getAlgorithm).anyMatch(arg_0 -> ((JWSAlgorithm)algorithm).equals(arg_0));
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        List<JWK> matches = this.matches(jwt, this.getJWKSet().orElse(null), this.getRefreshJwksAttempts());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Found {} matching JWKs", (Object)matches.size());
        }
        if (matches == null || matches.isEmpty()) {
            return false;
        }
        return this.verify(matches, jwt);
    }

    @Nullable
    protected JWKSet loadJwkSet(String url) {
        if (url == null) {
            return null;
        }
        try {
            return JWKSet.load((URL)new URL(url));
        }
        catch (IOException | ParseException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Exception loading JWK from " + url + ". The JwksSignature will not be used to verify a JWT if further refresh attempts fail", (Throwable)e);
            }
            return null;
        }
    }

    protected List<JWK> matches(SignedJWT jwt, @Nullable JWKSet jwkSet, int refreshKeysAttempts) {
        List matches = Collections.emptyList();
        if (jwkSet != null) {
            String keyId;
            JWKMatcher.Builder builder = new JWKMatcher.Builder();
            if (this.keyType != null) {
                builder = builder.keyType(this.keyType);
            }
            if ((keyId = jwt.getHeader().getKeyID()) != null) {
                builder = builder.keyID(keyId);
            }
            matches = new JWKSelector(builder.build()).select(jwkSet);
        }
        if (refreshKeysAttempts > 0 && matches.isEmpty()) {
            this.jwkSet = null;
            return this.matches(jwt, this.getJWKSet().orElse(null), refreshKeysAttempts - 1);
        }
        return matches;
    }

    protected boolean verify(List<JWK> matches, SignedJWT jwt) {
        return matches.stream().anyMatch(jwk -> this.jwkValidator.validate(jwt, (JWK)jwk));
    }

    public int getRefreshJwksAttempts() {
        return 1;
    }

    public JwkValidator getJwkValidator() {
        return this.jwkValidator;
    }

    public JWKSet getJwkSet() {
        return this.jwkSet;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public String getUrl() {
        return this.url;
    }
}

