/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.signature.rsa;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.SignedJWT;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.token.jwt.signature.AbstractSignatureConfiguration;
import io.micronaut.security.token.jwt.signature.rsa.RSASignatureConfiguration;
import java.security.interfaces.RSAPublicKey;

public class RSASignature
extends AbstractSignatureConfiguration {
    private RSAPublicKey publicKey;

    public RSASignature(RSASignatureConfiguration config) {
        this.publicKey = config.getPublicKey();
    }

    @Override
    public String supportedAlgorithmsMessage() {
        return "Only the RS256, RS384, RS512, PS256, PS384 and PS512 algorithms are supported for RSA signature";
    }

    @Override
    public boolean supports(JWSAlgorithm algorithm) {
        return algorithm != null && RSASSAVerifier.SUPPORTED_ALGORITHMS.contains(algorithm);
    }

    @Override
    public boolean verify(SignedJWT jwt) throws JOSEException {
        return this.verifyWithPublicKey(jwt, this.publicKey);
    }

    private boolean verifyWithPublicKey(SignedJWT jwt, @NonNull RSAPublicKey publicKey) throws JOSEException {
        RSASSAVerifier verifier = new RSASSAVerifier(publicKey);
        return jwt.verify((JWSVerifier)verifier);
    }
}

