/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.converters;

import com.nimbusds.jose.JWSAlgorithm;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JWSAlgorithmConverter
implements TypeConverter<CharSequence, JWSAlgorithm> {
    public Optional<JWSAlgorithm> convert(CharSequence object, Class<JWSAlgorithm> targetType, ConversionContext context) {
        if (object == null) {
            return Optional.empty();
        }
        String value = object.toString();
        JWSAlgorithm algorithm = JWSAlgorithm.parse((String)value);
        if (algorithm.getRequirement() != null) {
            return Optional.of(algorithm);
        }
        return Optional.empty();
    }
}

