/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.endpoints;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.annotation.Consumes;
import io.micronaut.http.annotation.Controller;
import io.micronaut.http.annotation.CookieValue;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.Post;
import io.micronaut.security.annotation.Secured;
import io.micronaut.security.errors.ErrorCode;
import io.micronaut.security.errors.IssuingAnAccessTokenErrorCode;
import io.micronaut.security.errors.OauthErrorResponseException;
import io.micronaut.security.handlers.LoginHandler;
import io.micronaut.security.token.jwt.endpoints.OauthControllerConfigurationProperties;
import io.micronaut.security.token.jwt.endpoints.TokenRefreshRequest;
import io.micronaut.security.token.refresh.RefreshTokenPersistence;
import io.micronaut.security.token.validator.RefreshTokenValidator;
import io.micronaut.validation.Validated;
import io.reactivex.Single;
import java.util.Optional;
import org.reactivestreams.Publisher;

@Requirements(value={@Requires(property="micronaut.security.endpoints.oauth.enabled", notEquals="false"), @Requires(beans={RefreshTokenPersistence.class}), @Requires(beans={RefreshTokenValidator.class})})
@Controller(value="${micronaut.security.endpoints.oauth.path:/oauth/access_token}")
@Secured(value={"isAnonymous()"})
@Validated
public class OauthController {
    private final RefreshTokenPersistence refreshTokenPersistence;
    private final RefreshTokenValidator refreshTokenValidator;
    private final OauthControllerConfigurationProperties oauthControllerConfigurationProperties;
    private final LoginHandler loginHandler;

    public OauthController(RefreshTokenPersistence refreshTokenPersistence, RefreshTokenValidator refreshTokenValidator, OauthControllerConfigurationProperties oauthControllerConfigurationProperties, LoginHandler loginHandler) {
        this.refreshTokenPersistence = refreshTokenPersistence;
        this.refreshTokenValidator = refreshTokenValidator;
        this.oauthControllerConfigurationProperties = oauthControllerConfigurationProperties;
        this.loginHandler = loginHandler;
    }

    @Consumes(value={"application/x-www-form-urlencoded", "application/json"})
    @Post
    public Single<MutableHttpResponse<?>> index(HttpRequest<?> request, @Body @Nullable TokenRefreshRequest tokenRefreshRequest, @CookieValue(value="JWT_REFRESH_TOKEN") @Nullable String cookieRefreshToken) {
        String refreshToken = this.resolveRefreshToken(tokenRefreshRequest, cookieRefreshToken);
        return this.createResponse(request, refreshToken);
    }

    @Get
    public Single<MutableHttpResponse<?>> index(HttpRequest<?> request, @CookieValue(value="JWT_REFRESH_TOKEN") @Nullable String cookieRefreshToken) {
        if (!this.oauthControllerConfigurationProperties.isGetAllowed()) {
            return Single.just((Object)HttpResponse.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED));
        }
        String refreshToken = this.resolveRefreshToken(null, cookieRefreshToken);
        return this.createResponse(request, refreshToken);
    }

    private Single<MutableHttpResponse<?>> createResponse(HttpRequest<?> request, String refreshToken) {
        Optional validRefreshToken = this.refreshTokenValidator.validate(refreshToken);
        if (!validRefreshToken.isPresent()) {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_GRANT, "Refresh token is invalid", null);
        }
        return Single.fromPublisher((Publisher)this.refreshTokenPersistence.getUserDetails((String)validRefreshToken.get())).map(userDetails -> this.loginHandler.loginRefresh(userDetails, refreshToken, request));
    }

    @NonNull
    private String resolveRefreshToken(TokenRefreshRequest tokenRefreshRequest, String cookieRefreshToken) {
        String refreshToken = null;
        if (tokenRefreshRequest != null) {
            if (StringUtils.isEmpty((CharSequence)tokenRefreshRequest.getGrantType()) || StringUtils.isEmpty((CharSequence)tokenRefreshRequest.getRefreshToken())) {
                throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token and grant_type are required", null);
            }
            if (!tokenRefreshRequest.getGrantType().equals("refresh_token")) {
                throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.UNSUPPORTED_GRANT_TYPE, "grant_type must be refresh_token", null);
            }
            refreshToken = tokenRefreshRequest.getRefreshToken();
        } else if (cookieRefreshToken != null) {
            refreshToken = cookieRefreshToken;
        }
        if (StringUtils.isEmpty((CharSequence)refreshToken)) {
            throw new OauthErrorResponseException((ErrorCode)IssuingAnAccessTokenErrorCode.INVALID_REQUEST, "refresh_token is required", null);
        }
        return refreshToken;
    }
}

