/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jwt.JWTClaimsSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.micronaut.context.annotation.Requires;
import io.micronaut.security.token.jwt.generator.claims.JwtClaims;
import io.micronaut.security.token.jwt.validator.GenericJwtClaimsValidator;
import io.micronaut.security.token.jwt.validator.JWTClaimsSetUtils;
import java.util.Date;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.security.token.jwt.claims-validators.expiration", notEquals="false")
public class ExpirationJwtClaimsValidator
implements GenericJwtClaimsValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ExpirationJwtClaimsValidator.class);

    protected boolean validate(@NonNull JWTClaimsSet claimsSet) {
        Date now;
        Date expTime = claimsSet.getExpirationTime();
        if (expTime != null && expTime.before(now = new Date())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT token has expired");
            }
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean validate(JwtClaims claims) {
        return this.validate(JWTClaimsSetUtils.jwtClaimsSetFromClaims(claims));
    }
}

