/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.converters;

import com.nimbusds.jose.JWEAlgorithm;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Optional;
import javax.inject.Singleton;

@Singleton
public class JWEAlgorithmConverter
implements TypeConverter<CharSequence, JWEAlgorithm> {
    public Optional<JWEAlgorithm> convert(CharSequence object, Class<JWEAlgorithm> targetType, ConversionContext context) {
        if (object == null) {
            return Optional.empty();
        }
        String value = object.toString();
        JWEAlgorithm algorithm = JWEAlgorithm.parse((String)value);
        if (algorithm.getRequirement() != null) {
            return Optional.of(algorithm);
        }
        return Optional.empty();
    }
}

