/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.validator;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import io.micronaut.security.token.jwt.generator.claims.JwtClaimsSetAdapter;
import io.micronaut.security.token.jwt.signature.SignatureConfiguration;
import io.micronaut.security.token.jwt.validator.JwtClaimsValidator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtValidator {
    private static final Logger LOG = LoggerFactory.getLogger(JwtValidator.class);
    private static final String DOT = ".";
    private final List<SignatureConfiguration> signatures;
    private final List<EncryptionConfiguration> encryptions;
    private final List<JwtClaimsValidator> claimsValidators;

    private JwtValidator(List<SignatureConfiguration> signatures, List<EncryptionConfiguration> encryptions, List<JwtClaimsValidator> claimsValidators) {
        this.signatures = signatures;
        this.encryptions = encryptions;
        this.claimsValidators = claimsValidators;
    }

    @Deprecated
    public Optional<JWT> validate(String token) {
        return this.validate(token, null);
    }

    public Optional<JWT> validate(String token, @Nullable HttpRequest<?> request) {
        block4: {
            try {
                if (this.hasAtLeastTwoDots(token)) {
                    JWT jwt = JWTParser.parse((String)token);
                    return this.validate(jwt, request);
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("token {} does not contain two dots", (Object)token);
                }
            }
            catch (ParseException e) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace("Failed to parse JWT: {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    private boolean hasAtLeastTwoDots(String token) {
        return token.contains(DOT) && token.indexOf(DOT, token.indexOf(DOT) + 1) != -1;
    }

    @Deprecated
    public Optional<JWT> validate(JWT token) {
        return this.validate(token, null);
    }

    public Optional<JWT> validate(@NonNull JWT token, @Nullable HttpRequest<?> request) {
        Optional<Object> validationResult = token instanceof PlainJWT ? this.validate((PlainJWT)token) : (token instanceof EncryptedJWT ? this.validate((EncryptedJWT)token) : (token instanceof SignedJWT ? this.validate((SignedJWT)token) : Optional.empty()));
        if (this.claimsValidators.isEmpty()) {
            return validationResult;
        }
        return validationResult.filter(jwt -> {
            try {
                JwtClaimsSetAdapter claims = new JwtClaimsSetAdapter(jwt.getJWTClaimsSet());
                return this.claimsValidators.stream().allMatch(validator -> validator.validate(claims, request));
            }
            catch (ParseException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Failed to retrieve the claims set", (Throwable)e);
                }
                return false;
            }
        });
    }

    private Optional<JWT> validate(PlainJWT jwt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating plain JWT");
        }
        if (this.signatures.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JWT is not signed and no signature configurations -> verified");
            }
            return Optional.of(jwt);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("A non-signed JWT cannot be accepted as signature configurations have been defined");
        }
        return Optional.empty();
    }

    private Optional<JWT> validate(EncryptedJWT jwt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating encrypted JWT");
        }
        JWEHeader header = jwt.getHeader();
        ArrayList<EncryptionConfiguration> sortedConfigs = new ArrayList<EncryptionConfiguration>(this.encryptions);
        sortedConfigs.sort(JwtValidator.comparator(header));
        Iterator iterator = sortedConfigs.iterator();
        if (iterator.hasNext()) {
            EncryptionConfiguration config = (EncryptionConfiguration)iterator.next();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Using encryption configuration: {}", (Object)config.toString());
            }
            try {
                config.decrypt(jwt);
                SignedJWT signedJWT = jwt.getPayload().toSignedJWT();
                if (signedJWT == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Encrypted JWT couldn't be converted to a signed JWT.");
                    }
                    return Optional.empty();
                }
                return this.validate(signedJWT);
            }
            catch (JOSEException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Decryption fails with encryption configuration: {}, passing to the next one", (Object)config.toString());
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<JWT> validate(SignedJWT jwt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Validating signed JWT");
        }
        JWSAlgorithm algorithm = jwt.getHeader().getAlgorithm();
        ArrayList<SignatureConfiguration> sortedConfigs = new ArrayList<SignatureConfiguration>(this.signatures);
        sortedConfigs.sort(JwtValidator.comparator(algorithm));
        for (SignatureConfiguration config : sortedConfigs) {
            try {
                boolean verified = config.verify(jwt);
                if (!verified) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("JWT Signature verification failed: {}", (Object)jwt.getParsedString());
                    continue;
                }
                return Optional.of(jwt);
            }
            catch (JOSEException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Verification failed with signature configuration: {}, passing to the next one", (Object)config);
            }
        }
        return Optional.empty();
    }

    private static Comparator<SignatureConfiguration> comparator(JWSAlgorithm algorithm) {
        return (sig, otherSig) -> {
            boolean otherSupports;
            boolean supports = sig.supports(algorithm);
            if (supports == (otherSupports = otherSig.supports(algorithm))) {
                return 0;
            }
            if (supports) {
                return -1;
            }
            return 1;
        };
    }

    private static Comparator<EncryptionConfiguration> comparator(JWEHeader header) {
        JWEAlgorithm algorithm = header.getAlgorithm();
        EncryptionMethod method = header.getEncryptionMethod();
        return (sig, otherSig) -> {
            boolean otherSupports;
            boolean supports = sig.supports(algorithm, method);
            if (supports == (otherSupports = otherSig.supports(algorithm, method))) {
                return 0;
            }
            if (supports) {
                return -1;
            }
            return 1;
        };
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<SignatureConfiguration> signatures = new ArrayList<SignatureConfiguration>();
        private List<EncryptionConfiguration> encryptions = new ArrayList<EncryptionConfiguration>();
        private List<JwtClaimsValidator> claimsValidators = new ArrayList<JwtClaimsValidator>();

        private Builder() {
        }

        public Builder withSignatures(SignatureConfiguration ... signatureConfigurations) {
            this.signatures = Arrays.asList(signatureConfigurations);
            return this;
        }

        public Builder withSignatures(Collection<? extends SignatureConfiguration> signatureConfigurations) {
            this.signatures = new ArrayList<SignatureConfiguration>(signatureConfigurations);
            return this;
        }

        public Builder withEncryptions(EncryptionConfiguration ... encryptionConfigurations) {
            this.encryptions = Arrays.asList(encryptionConfigurations);
            return this;
        }

        public Builder withEncryptions(Collection<? extends EncryptionConfiguration> encryptionConfigurations) {
            this.encryptions = new ArrayList<EncryptionConfiguration>(encryptionConfigurations);
            return this;
        }

        public Builder withClaimValidators(JwtClaimsValidator ... jwtClaimsValidators) {
            this.claimsValidators = Arrays.asList(jwtClaimsValidators);
            return this;
        }

        public Builder withClaimValidators(Collection<? extends JwtClaimsValidator> jwtClaimsValidators) {
            this.claimsValidators = new ArrayList<JwtClaimsValidator>(jwtClaimsValidators);
            return this;
        }

        public JwtValidator build() {
            return new JwtValidator(this.signatures, this.encryptions, this.claimsValidators);
        }
    }
}

