/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.repository;

import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.security.csrf.repository.CsrfTokenRepository;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Optional;

@Internal
@Primary
@Singleton
final class CompositeCsrfTokenRepository<T>
implements CsrfTokenRepository<T> {
    private final List<CsrfTokenRepository<T>> repositories;

    public CompositeCsrfTokenRepository(List<CsrfTokenRepository<T>> repositories) {
        this.repositories = repositories;
    }

    @Override
    @NonNull
    public Optional<String> findCsrfToken(@NonNull T request) {
        return this.repositories.stream().flatMap(r -> r.findCsrfToken(request).stream()).findFirst();
    }
}

