/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.repository;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.repository.CsrfTokenRepository;
import jakarta.inject.Singleton;
import java.util.Optional;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(property="micronaut.security.csrf.repository.cookie.enabled", value="true", defaultValue="true")})
@Singleton
public class CookieCsrfTokenRepository
implements CsrfTokenRepository<HttpRequest<?>> {
    private final CsrfConfiguration csrfConfiguration;

    public CookieCsrfTokenRepository(CsrfConfiguration csrfConfiguration) {
        this.csrfConfiguration = csrfConfiguration;
    }

    @Override
    @NonNull
    public Optional<String> findCsrfToken(@NonNull HttpRequest<?> request) {
        return request.getCookies().findCookie((CharSequence)this.csrfConfiguration.getCookieName()).map(Cookie::getValue);
    }
}

