/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.generator;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.cookie.CookieConfiguration;
import io.micronaut.security.csrf.CsrfConfiguration;
import io.micronaut.security.csrf.generator.CsrfHmacTokenGenerator;
import io.micronaut.security.session.SessionIdResolver;
import io.micronaut.security.utils.HMacUtils;
import jakarta.inject.Singleton;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

@Requires(classes={CookieConfiguration.class})
@Singleton
final class DefaultCsrfTokenGenerator<T>
implements CsrfHmacTokenGenerator<T> {
    private static final String SESSION_RANDOM_SEPARATOR = "!";
    private final SecureRandom secureRandom = new SecureRandom();
    private final CsrfConfiguration csrfConfiguration;
    private final SessionIdResolver<T> sessionIdResolver;

    DefaultCsrfTokenGenerator(CsrfConfiguration csrfConfiguration, SessionIdResolver<T> sessionIdResolver) {
        this.csrfConfiguration = csrfConfiguration;
        this.sessionIdResolver = sessionIdResolver;
    }

    @Override
    @NonNull
    public String generateCsrfToken(@NonNull T request) {
        byte[] tokenBytes = new byte[this.csrfConfiguration.getRandomValueSize()];
        this.secureRandom.nextBytes(tokenBytes);
        String randomValue = Base64.getUrlEncoder().withoutPadding().encodeToString(tokenBytes);
        String hmac = this.hmac(request, randomValue);
        return hmac + "." + randomValue;
    }

    @Override
    @NonNull
    public String hmac(@NonNull T request, @NonNull String base64EncodedRandomValue) {
        String secret = this.csrfConfiguration.getSecretKey();
        String sessionID = this.sessionIdResolver.findSessionId(request).orElse("");
        String message = DefaultCsrfTokenGenerator.hmacMessagePayload(sessionID, base64EncodedRandomValue);
        try {
            return StringUtils.isNotEmpty((CharSequence)secret) ? HMacUtils.base64EncodedHmacSha256((String)message, (String)secret) : "";
        }
        catch (InvalidKeyException ex) {
            throw new ConfigurationException("Invalid secret key for signing the CSRF token");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ConfigurationException("Invalid algorithm for signing the CSRF token");
        }
    }

    static String hmacMessagePayload(String sessionId, String randomValue) {
        String base64SessionId = Base64.getEncoder().encodeToString(sessionId.getBytes());
        return base64SessionId.length() + SESSION_RANDOM_SEPARATOR + base64SessionId + SESSION_RANDOM_SEPARATOR + randomValue.length() + SESSION_RANDOM_SEPARATOR + randomValue;
    }
}

