/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.cookie.SameSite;
import io.micronaut.security.csrf.CsrfConfiguration;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Optional;

@Internal
@ConfigurationProperties(value="micronaut.security.csrf")
final class CsrfConfigurationProperties
implements CsrfConfiguration {
    public static final String DEFAULT_HTTP_HEADER_NAME = "X-CSRF-TOKEN";
    public static final String DEFAULT_FIELD_NAME = "csrfToken";
    public static final String DEFAULT_COOKIE_NAME = "__Host-csrfToken";
    public static final String DEFAULT_HTTP_SESSION_NAME = "csrfToken";
    public static final SameSite DEFAULT_SAME_SITE = SameSite.Strict;
    public static final int DEFAULT_RANDOM_VALUE_SIZE = 16;
    public static final boolean DEFAULT_ENABLED = true;
    private static final boolean DEFAULT_HTTPONLY = true;
    private static final String DEFAULT_COOKIEPATH = "/";
    private static final Boolean DEFAULT_SECURE = true;
    private static final Duration DEFAULT_MAX_AGE = Duration.ofSeconds(3600L);
    private boolean enabled = true;
    private String headerName = "X-CSRF-TOKEN";
    private String fieldName = "csrfToken";
    private int randomValueSize = 16;
    private String httpSessionName = "csrfToken";
    @Nullable
    private String cookieDomain;
    private Boolean cookieSecure = DEFAULT_SECURE;
    private String cookiePath = "/";
    private Boolean cookieHttpOnly = true;
    private Duration cookieMaxAge = DEFAULT_MAX_AGE;
    private String cookieName = "__Host-csrfToken";
    private SameSite sameSite = DEFAULT_SAME_SITE;
    @Nullable
    private String signatureKey;
    private boolean sessionCookie;

    CsrfConfigurationProperties() {
    }

    @Override
    public boolean isSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(boolean sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    @Override
    @Nullable
    public String getSecretKey() {
        return this.signatureKey;
    }

    public void setSignatureKey(@Nullable String signatureKey) {
        this.signatureKey = signatureKey;
    }

    @Override
    @NonNull
    public String getHttpSessionName() {
        return this.httpSessionName;
    }

    public void setHttpSessionName(@NonNull String httpSessionName) {
        this.httpSessionName = httpSessionName;
    }

    @Override
    public int getRandomValueSize() {
        return this.randomValueSize;
    }

    public void setRandomValueSize(int randomValueSize) {
        this.randomValueSize = randomValueSize;
    }

    @Override
    @NonNull
    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(@NonNull String headerName) {
        this.headerName = headerName;
    }

    @Override
    @NonNull
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(@NonNull String fieldName) {
        this.fieldName = fieldName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Optional<String> getCookieDomain() {
        return Optional.ofNullable(this.cookieDomain);
    }

    public void setCookieDomain(@Nullable String cookieDomain) {
        this.cookieDomain = cookieDomain;
    }

    public Optional<Boolean> isCookieSecure() {
        return Optional.ofNullable(this.cookieSecure);
    }

    public void setCookieSecure(Boolean cookieSecure) {
        this.cookieSecure = cookieSecure;
    }

    @NonNull
    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(@NonNull String cookieName) {
        this.cookieName = cookieName;
    }

    public Optional<String> getCookiePath() {
        return Optional.ofNullable(this.cookiePath);
    }

    public void setCookiePath(@Nullable String cookiePath) {
        this.cookiePath = cookiePath;
    }

    public Optional<Boolean> isCookieHttpOnly() {
        return Optional.ofNullable(this.cookieHttpOnly);
    }

    public void setCookieHttpOnly(Boolean cookieHttpOnly) {
        this.cookieHttpOnly = cookieHttpOnly;
    }

    public Optional<TemporalAmount> getCookieMaxAge() {
        if (this.isSessionCookie()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.cookieMaxAge);
    }

    public void setCookieMaxAge(Duration cookieMaxAge) {
        this.cookieMaxAge = cookieMaxAge;
    }

    public Optional<SameSite> getCookieSameSite() {
        return Optional.of(this.sameSite);
    }

    public void setCookieSameSite(SameSite sameSite) {
        this.sameSite = sameSite;
    }
}

