/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.csrf.filter;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.MediaType;
import io.micronaut.security.csrf.filter.CsrfFilterConfiguration;
import java.util.Set;

@Requires(classes={HttpMethod.class, MediaType.class})
@Internal
@ConfigurationProperties(value="micronaut.security.csrf.filter")
final class CsrfFilterConfigurationProperties
implements CsrfFilterConfiguration {
    public static final String PREFIX = "micronaut.security.csrf.filter";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String DEFAULT_REGEX_PATTERN = "^.*$";
    private static final Set<HttpMethod> DEFAULT_METHODS = Set.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.PATCH);
    private static final Set<MediaType> DEFAULT_CONTENT_TYPES = Set.of(MediaType.APPLICATION_FORM_URLENCODED_TYPE, MediaType.MULTIPART_FORM_DATA_TYPE);
    private boolean enabled = true;
    private String regexPattern = "^.*$";
    private Set<HttpMethod> methods = DEFAULT_METHODS;
    private Set<MediaType> contentTypes = DEFAULT_CONTENT_TYPES;

    CsrfFilterConfigurationProperties() {
    }

    @Override
    @NonNull
    public Set<HttpMethod> getMethods() {
        return this.methods;
    }

    public void setMethods(@NonNull Set<HttpMethod> methods) {
        this.methods = methods;
    }

    @Override
    @NonNull
    public Set<MediaType> getContentTypes() {
        return this.contentTypes;
    }

    public void setContentTypes(@NonNull Set<MediaType> contentTypes) {
        this.contentTypes = contentTypes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getRegexPattern() {
        return this.regexPattern;
    }

    public void setRegexPattern(String regexPattern) {
        this.regexPattern = regexPattern;
    }
}

